/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class SpringPropertiesPostProcessor
implements EnvironmentPostProcessor {
    public static final String SPRING_HTTP2_ENABLED_PROPERTY = "server.http2.enabled";
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Map<String, Object> propertiesToAddMap = this.createSpringProperties();
        this.addToDefaultProperties(environment.getPropertySources(), propertiesToAddMap);
    }

    private Map<String, Object> createSpringProperties() {
        ConfigurationService preAutowireConfigService = ConfigurationService.createDefault();
        return Map.of(SPRING_HTTP2_ENABLED_PROPERTY, preAutowireConfigService.getContainerHttp2Enabled());
    }

    private void addToDefaultProperties(MutablePropertySources propertySources, Map<String, Object> propertiesToAddMap) {
        Optional.ofNullable(propertySources.get(PROPERTY_SOURCE_NAME)).filter(MapPropertySource.class::isInstance).map(MapPropertySource.class::cast).ifPresentOrElse(propertySource -> {
            for (String key : propertiesToAddMap.keySet()) {
                if (propertySource.containsProperty(key)) continue;
                ((Map)propertySource.getSource()).put(key, propertiesToAddMap.get(key));
            }
        }, () -> propertySources.addLast((PropertySource)new MapPropertySource(PROPERTY_SOURCE_NAME, propertiesToAddMap)));
    }
}

