/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.util;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractEndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.AdHocSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.InclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.SendTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import java.time.Duration;
import java.util.function.Consumer;

public class ZeebeBpmnModels {
    public static final String ACTIVATE_ELEMENTS = "activateElements";
    public static final String ADHOC_SUB_PROCESS = "adhocSubProcess";
    public static final String START_EVENT = "startEvent";
    public static final String SERVICE_TASK = "service_task";
    public static final String SEND_TASK = "send_task";
    public static final String USER_TASK = "user_task";
    public static final String END_EVENT = "end";
    public static final String END_EVENT_2 = "end2";
    public static final String TERMINATE_END_EVENT = "terminate-end";
    public static final String CATCH_EVENT = "catchEvent";
    public static final String CONVERGING_GATEWAY = "converging_gateway";
    public static final String DIVERGING_GATEWAY = "diverging_gateway";
    public static final String SIGNAL_START_EVENT = "signalStartEvent";
    public static final String SIGNAL_START_INT_SUB_PROCESS = "signalStartInterruptingSubProcessEvent";
    public static final String SIGNAL_START_NON_INT_SUB_PROCESS = "signalStartNonInterruptingSubProcessEvent";
    public static final String SIGNAL_GATEWAY_CATCH = "signalIntermediateCatchEventAttachedToEventBasedGateway";
    public static final String SIGNAL_THROW = "signalIntermediateThrowEvent";
    public static final String SIGNAL_CATCH = "signalIntermediateCatchEvent";
    public static final String SIGNAL_INTERRUPTING_BOUNDARY = "signalIntermediateBoundaryInterruptingEvent";
    public static final String SIGNAL_NON_INTERRUPTING_BOUNDARY = "signalIntermediateBoundaryNonInterruptingEvent";
    public static final String SIGNAL_PROCESS_WAIT_FOR_FIRST_SIGNAL_TASK = "signalProcessServiceTask1";
    public static final String SIGNAL_PROCESS_WAIT_FOR_SECOND_SIGNAL_TASK = "signalProcessServiceTask2";
    public static final String SIGNAL_PROCESS_WAIT_FOR_THIRD_SIGNAL_GATEWAY = "eventBasedGateway";
    public static final String SIGNAL_PROCESS_END = "signalEndEvent";
    public static final String SIGNAL_PROCESS_FIRST_SIGNAL = "nonInterruptingBoundarySignal";
    public static final String SIGNAL_PROCESS_SECOND_SIGNAL = "interruptingBoundarySignal";
    public static final String SIGNAL_PROCESS_THIRD_SIGNAL = "eventBasedGatewaySignal";
    public static final String SERVICE_TASK_WITH_COMPENSATION_EVENT = "compensationEvent";
    public static final String TASK = "task";
    public static final String COMPENSATION_EVENT_TASK = "compensationEventTask";
    public static final String VERSION_TAG = "v1";

    private ZeebeBpmnModels() {
    }

    public static BpmnModelInstance createStartEndProcess(String processName) {
        return ZeebeBpmnModels.createStartEndProcess(processName, null);
    }

    public static BpmnModelInstance createStartEndProcess(String processName, String processId) {
        ProcessBuilder executableProcess = Bpmn.createExecutableProcess();
        if (processId != null) {
            executableProcess = (ProcessBuilder)executableProcess.id(processId);
        }
        return ((EndEventBuilder)((StartEventBuilder)((ProcessBuilder)executableProcess.name(processName)).startEvent(START_EVENT).name(START_EVENT)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createSimpleServiceTaskProcess(String processName) {
        return ((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)processName).name(processName)).startEvent(START_EVENT).name(START_EVENT)).serviceTask(SERVICE_TASK).zeebeJobType(SERVICE_TASK)).name(SERVICE_TASK)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createAdHocSubProcess(String processName, Consumer<AdHocSubProcessBuilder> modifier) {
        return ((ProcessBuilder)Bpmn.createExecutableProcess((String)processName).name(processName)).startEvent(START_EVENT).adHocSubProcess(ADHOC_SUB_PROCESS, modifier).endEvent(END_EVENT).done();
    }

    public static BpmnModelInstance createSingleStartDoubleEndEventProcess(String processName) {
        return ((ProcessBuilder)Bpmn.createExecutableProcess((String)processName).name(processName)).startEvent(START_EVENT).parallelGateway().endEvent(END_EVENT).moveToLastGateway().endEvent(END_EVENT_2).done();
    }

    public static BpmnModelInstance createTerminateEndEventProcess(String processName) {
        return ((ProcessBuilder)Bpmn.createExecutableProcess((String)processName).name(processName)).startEvent().endEvent(TERMINATE_END_EVENT, AbstractEndEventBuilder::terminate).done();
    }

    public static BpmnModelInstance createIncidentProcess(String processName) {
        return ((EndEventBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)processName).name(processName)).startEvent(START_EVENT).name(START_EVENT)).intermediateCatchEvent(CATCH_EVENT, e -> e.message(m -> m.name("catch").zeebeCorrelationKeyExpression("orderId"))).endEvent(END_EVENT_2).name(null)).done();
    }

    public static BpmnModelInstance createSimpleUserTaskProcess(String processName) {
        return ((EndEventBuilder)((UserTaskBuilder)((UserTaskBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).versionTag(VERSION_TAG).startEvent(START_EVENT).name(START_EVENT)).userTask(USER_TASK).id(USER_TASK)).name(USER_TASK)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createSimpleNativeUserTaskProcessWithAssignee(String processName, String dueDate, String assignee) {
        return ((EndEventBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).name(START_EVENT)).userTask(USER_TASK).zeebeUserTask()).id(USER_TASK)).name(USER_TASK)).zeebeDueDate(dueDate)).zeebeAssignee(assignee)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createSimpleNativeUserTaskProcess(String processName, String dueDate) {
        return ((EndEventBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).name(START_EVENT)).userTask(USER_TASK).zeebeUserTask()).id(USER_TASK)).name(USER_TASK)).zeebeDueDate(dueDate)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createSimpleNativeUserTaskProcessWithCandidateGroup(String processName, String dueDate, String candidateGroup) {
        return ((EndEventBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((UserTaskBuilder)((StartEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).name(START_EVENT)).userTask(USER_TASK).zeebeUserTask()).id(USER_TASK)).name(USER_TASK)).zeebeDueDate(dueDate)).zeebeCandidateGroups(candidateGroup)).endEvent(END_EVENT).name(null)).done();
    }

    public static BpmnModelInstance createLoopingProcess(String processName) {
        return ((ExclusiveGatewayBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).exclusiveGateway(CONVERGING_GATEWAY).serviceTask(SERVICE_TASK).zeebeJobType(SERVICE_TASK)).exclusiveGateway(DIVERGING_GATEWAY).condition("End process", "=loop=false")).endEvent(END_EVENT).moveToNode(DIVERGING_GATEWAY).condition("Do Loop", "=loop=true").connectTo(CONVERGING_GATEWAY).done();
    }

    public static BpmnModelInstance createInclusiveGatewayProcess(String processName) {
        return ((AbstractGatewayBuilder)((AbstractGatewayBuilder)((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).inclusiveGateway(DIVERGING_GATEWAY).sequenceFlowId("s1")).conditionExpression("= contains(varName,\"a\")")).endEvent(END_EVENT).moveToLastGateway().sequenceFlowId("s2")).conditionExpression("= contains(varName,\"b\")")).endEvent(END_EVENT_2).done();
    }

    public static BpmnModelInstance createCompensationEventProcess() {
        return Bpmn.createExecutableProcess().startEvent().serviceTask(SERVICE_TASK_WITH_COMPENSATION_EVENT, task -> ((ServiceTaskBuilder)task.zeebeJobType(SERVICE_TASK_WITH_COMPENSATION_EVENT)).boundaryEvent().compensation(compensation -> compensation.serviceTask(COMPENSATION_EVENT_TASK).zeebeJobType(COMPENSATION_EVENT_TASK))).endEvent().compensateEventDefinition().done();
    }

    public static BpmnModelInstance createInclusiveGatewayProcessWithConverging(String processName) {
        return ((InclusiveGatewayBuilder)((InclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processName).startEvent(START_EVENT).inclusiveGateway(DIVERGING_GATEWAY).sequenceFlowId("s1")).conditionExpression("= contains(varName,\"a\")")).inclusiveGateway(CONVERGING_GATEWAY).endEvent(END_EVENT).done();
    }

    public static BpmnModelInstance createSendTaskProcess(String processName) {
        return ((SendTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess().name(processName)).startEvent(START_EVENT).sendTask(SEND_TASK).zeebeJobType(SEND_TASK)).done();
    }

    public static BpmnModelInstance createProcessWith83SignalEvents(String startSignalName) {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"signalProcess");
        processBuilder.eventSubProcess("interruptingSubProcess").startEvent(SIGNAL_START_INT_SUB_PROCESS, s -> ((StartEventBuilder)s.signal("signalToStartInterruptingSubProcess")).interrupting(true)).endEvent("interruptingSubProcessEnd");
        processBuilder.eventSubProcess("nonInterruptingSubProcess").startEvent(SIGNAL_START_NON_INT_SUB_PROCESS, s -> ((StartEventBuilder)s.signal("signalToStartNonInterruptingSubProcess")).interrupting(false)).endEvent("nonInterruptingSubProcessEnd", s -> s.signal("signalToContinueProcessAfterNonInterruptingSubProcess"));
        return ((BoundaryEventBuilder)((ServiceTaskBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)((StartEventBuilder)processBuilder.startEvent(SIGNAL_START_EVENT).signal(startSignalName)).intermediateThrowEvent(SIGNAL_THROW, t -> t.signal("signalToStartNonInterruptingSubProcess")).intermediateCatchEvent(SIGNAL_CATCH, c -> c.signal("signalToContinueProcessAfterNonInterruptingSubProcess")).serviceTask(SIGNAL_PROCESS_WAIT_FOR_FIRST_SIGNAL_TASK).zeebeJobType(SERVICE_TASK)).boundaryEvent(SIGNAL_NON_INTERRUPTING_BOUNDARY, b -> b.signal(SIGNAL_PROCESS_FIRST_SIGNAL)).cancelActivity(Boolean.valueOf(false))).serviceTask(SIGNAL_PROCESS_WAIT_FOR_SECOND_SIGNAL_TASK).zeebeJobType(SERVICE_TASK)).boundaryEvent(SIGNAL_INTERRUPTING_BOUNDARY, b -> b.signal(SIGNAL_PROCESS_SECOND_SIGNAL)).cancelActivity(Boolean.valueOf(true))).eventBasedGateway(SIGNAL_PROCESS_WAIT_FOR_THIRD_SIGNAL_GATEWAY).intermediateCatchEvent("timerEvent", t -> t.timerWithDuration(Duration.ofMinutes(1L))).moveToLastGateway().intermediateCatchEvent(SIGNAL_GATEWAY_CATCH, c -> c.signal(SIGNAL_PROCESS_THIRD_SIGNAL)).endEvent(SIGNAL_PROCESS_END, e -> e.signal("signalToStartInterruptingSubProcess")).done();
    }
}

