/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.Quantiles;
import com.tdunning.math.stats.TDigest;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.util.Precision;

public class DurationAggregationUtil {
    public static Double calculateExpectedValueGivenDurationsDefaultAggr(Number setDuration) {
        return Optional.ofNullable(setDuration).map(xva$0 -> DurationAggregationUtil.calculateExpectedValueGivenDurationsWithoutPercentileInterpolation(xva$0)).map(stats -> (Double)stats.get(new AggregationDto(AggregationType.AVERAGE))).orElse(null);
    }

    public static Double calculateExpectedValueGivenDurationsDefaultAggr(Number ... setDuration) {
        double aggregatedDuration = DurationAggregationUtil.calculateExpectedValueGivenDurationsWithoutPercentileInterpolation(setDuration).get(new AggregationDto(AggregationType.AVERAGE));
        return Precision.round((double)aggregatedDuration, (int)0);
    }

    public static AggregationDto[] getSupportedAggregationTypes() {
        List aggregationDtos = Arrays.stream(AggregationType.values()).filter(aggType -> !aggType.equals((Object)AggregationType.PERCENTILE)).map(AggregationDto::new).collect(Collectors.toList());
        aggregationDtos.addAll(List.of(new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(99.0)), new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(95.0)), new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(75.0)), new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(50.0)), new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(25.0))));
        return (AggregationDto[])aggregationDtos.toArray(AggregationDto[]::new);
    }

    public static AggregationDto[] getAggregationTypesAsListForProcessParts() {
        return (AggregationDto[])Arrays.stream(AggregationType.values()).filter(type -> !ImmutableSet.of((Object)AggregationType.PERCENTILE).contains(type)).map(AggregationDto::new).toArray(AggregationDto[]::new);
    }

    public static Map<AggregationDto, Double> calculateExpectedValueGivenDurationsWithoutPercentileInterpolation(Number ... setDuration) {
        TDigest tDigest = TDigest.createAvlTreeDigest((double)100.0);
        Arrays.stream(setDuration).forEach(duration -> tDigest.add(((Double)duration).doubleValue()));
        return DurationAggregationUtil.calculateExpectedValueGivenDurationsUsingPercentilesFunction(q -> Precision.round((double)tDigest.quantile(q.doubleValue()), (int)0), setDuration);
    }

    public static Map<AggregationDto, Double> calculateExpectedValueGivenDurationsWithPercentileInterpolation(Number ... setDuration) {
        return DurationAggregationUtil.calculateExpectedValueGivenDurationsUsingPercentilesFunction(percentile -> Quantiles.percentiles().index((int)(percentile * 100.0)).compute(Arrays.asList(setDuration)), setDuration);
    }

    private static Map<AggregationDto, Double> calculateExpectedValueGivenDurationsUsingPercentilesFunction(Function<Double, Double> percentileFunction, Number ... setDuration) {
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        Stream.of(setDuration).map(Number::longValue).forEach(arg_0 -> ((DescriptiveStatistics)statistics).addValue(arg_0));
        return ImmutableMap.of((Object)new AggregationDto(AggregationType.MIN), (Object)Precision.round((double)statistics.getMin(), (int)0), (Object)new AggregationDto(AggregationType.MAX), (Object)Precision.round((double)statistics.getMax(), (int)0), (Object)new AggregationDto(AggregationType.AVERAGE), (Object)Precision.round((double)statistics.getMean(), (int)0), (Object)new AggregationDto(AggregationType.SUM), (Object)Precision.round((double)statistics.getSum(), (int)0), (Object)new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(99.0)), (Object)Precision.round((double)percentileFunction.apply(0.99), (int)0), (Object)new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(95.0)), (Object)Precision.round((double)percentileFunction.apply(0.95), (int)0), (Object)new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(75.0)), (Object)Precision.round((double)percentileFunction.apply(0.75), (int)0), (Object)new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(50.0)), (Object)Precision.round((double)percentileFunction.apply(0.5), (int)0), (Object)new AggregationDto(AggregationType.PERCENTILE, Double.valueOf(25.0)), (Object)Precision.round((double)percentileFunction.apply(0.25), (int)0));
    }
}

