/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension.db;

import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Iterables;
import io.camunda.optimize.ApplicationContextProvider;
import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.dto.optimize.index.ImportIndexDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.dto.optimize.query.MetadataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.es.schema.TransportOptionsProvider;
import io.camunda.optimize.service.db.os.ExtendedOpenSearchClient;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.builders.OptimizeIndexOperationOS;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.schema.OpenSearchIndexSettingsBuilder;
import io.camunda.optimize.service.db.os.schema.OpenSearchMetadataService;
import io.camunda.optimize.service.db.os.schema.OpenSearchSchemaManager;
import io.camunda.optimize.service.db.os.schema.index.ExternalProcessVariableIndexOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.os.schema.index.TerminatedUserSessionIndexOS;
import io.camunda.optimize.service.db.os.schema.index.report.SingleProcessReportIndexOS;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.schema.DatabaseSchemaManager;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DatabaseHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.service.util.configuration.elasticsearch.DatabaseConnectionNodeConfiguration;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.test.it.extension.db.DatabaseTestService;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.optimize.test.repository.TestIndexRepositoryOS;
import io.camunda.optimize.test.util.DurationAggregationUtil;
import io.camunda.optimize.upgrade.os.OpenSearchClientBuilder;
import io.camunda.search.connect.plugin.PluginRepository;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.jetbrains.annotations.NotNull;
import org.mockserver.integration.ClientAndServer;
import org.opensearch.client.Request;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregation;
import org.opensearch.client.opensearch._types.aggregations.ValueCountAggregate;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.cluster.PutClusterSettingsRequest;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.AliasDefinition;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.ExistsRequest;
import org.opensearch.client.opensearch.indices.ExistsTemplateRequest;
import org.opensearch.client.opensearch.indices.GetAliasRequest;
import org.opensearch.client.opensearch.indices.GetAliasResponse;
import org.opensearch.client.opensearch.indices.GetIndexResponse;
import org.opensearch.client.opensearch.indices.GetMappingRequest;
import org.opensearch.client.opensearch.indices.GetMappingResponse;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.PutIndicesSettingsRequest;
import org.opensearch.client.opensearch.indices.RefreshRequest;
import org.opensearch.client.opensearch.indices.get_alias.IndexAliases;
import org.opensearch.client.opensearch.indices.get_mapping.IndexMappingRecord;
import org.opensearch.client.opensearch.snapshot.CreateRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.DeleteRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchDatabaseTestService
extends DatabaseTestService {
    private static final String MOCKSERVER_CLIENT_KEY = "MockServer";
    private static final Map<String, OptimizeOpenSearchClient> CLIENT_CACHE = new HashMap<String, OptimizeOpenSearchClient>();
    private static final ClientAndServer mockServerClient = OpenSearchDatabaseTestService.initMockServer();
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchDatabaseTestService.class);
    private String opensearchDatabaseVersion;
    private OptimizeOpenSearchClient prefixAwareOptimizeOpenSearchClient;
    private ExtendedOpenSearchClient extendedOpenSearchClient;

    public OpenSearchDatabaseTestService(String customIndexPrefix, boolean haveToClean) {
        super(customIndexPrefix, haveToClean);
        this.initOsClient();
        this.setTestIndexRepository(new TestIndexRepositoryOS(this.prefixAwareOptimizeOpenSearchClient));
    }

    private static ClientAndServer initMockServer() {
        return DatabaseTestService.initMockServer(IntegrationTestConfigurationUtil.createItConfigurationService().getOpenSearchConfiguration().getFirstConnectionNode());
    }

    @NotNull
    private static IndexRequest.Builder createIndexRequestBuilder(String indexName, String id, Object entry) {
        IndexRequest.Builder request = new IndexRequest.Builder().document(entry).index(indexName).id(id).refresh(Refresh.True);
        return request;
    }

    @Override
    public void beforeEach() {
        if (this.haveToClean) {
            LOG.info("Cleaning database...");
            this.cleanAndVerifyDatabase();
            LOG.info("All documents have been wiped out! Database has successfully been cleaned!");
        }
    }

    @Override
    public void afterEach() {
        if (this.prefixAwareOptimizeOpenSearchClient == CLIENT_CACHE.get(MOCKSERVER_CLIENT_KEY)) {
            LOG.info("Resetting all MockServer expectations and logs");
            mockServerClient.reset();
            LOG.info("No longer using OS MockServer");
            this.initOsClient();
        }
    }

    @Override
    public ClientAndServer useDBMockServer() {
        LOG.info("Using OpenSearch MockServer");
        if (CLIENT_CACHE.containsKey(MOCKSERVER_CLIENT_KEY)) {
            this.prefixAwareOptimizeOpenSearchClient = CLIENT_CACHE.get(MOCKSERVER_CLIENT_KEY);
        } else {
            ConfigurationService configurationService = this.createConfigurationService();
            DatabaseConnectionNodeConfiguration osConfig = configurationService.getOpenSearchConfiguration().getFirstConnectionNode();
            osConfig.setHost("localhost");
            osConfig.setHttpPort(mockServerClient.getLocalPort());
            this.createClientAndAddToCache(MOCKSERVER_CLIENT_KEY, configurationService);
        }
        return mockServerClient;
    }

    @Override
    public void refreshAllOptimizeIndices() {
        try {
            RefreshRequest refreshAllIndicesRequest = new RefreshRequest.Builder().index(this.getIndexNameService().getIndexPrefix() + "*", new String[0]).build();
            this.getOptimizeOpenSearchClient().getOpenSearchClient().indices().refresh(refreshAllIndicesRequest);
        }
        catch (Exception e) {
            throw new OptimizeIntegrationTestException("Could not refresh Optimize indices!", e);
        }
    }

    @Override
    public void addEntryToDatabase(String indexName, String id, Object entry) {
        IndexRequest.Builder request = OpenSearchDatabaseTestService.createIndexRequestBuilder(indexName, id, entry);
        IndexResponse response = this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().index(request);
        if (!response.shards().failures().isEmpty()) {
            String reason = String.format("Could not add entry to index %s with id %s and entry %s", indexName, id, entry);
            throw new OptimizeIntegrationTestException(reason);
        }
    }

    @Override
    public void addEntriesToDatabase(String indexName, Map<String, Object> idToEntryMap) {
        StreamSupport.stream(Iterables.partition(idToEntryMap.entrySet(), (int)10000).spliterator(), false).forEach(batch -> {
            ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
            for (Map.Entry idAndObject : batch) {
                IndexOperation.Builder operation = (IndexOperation.Builder)new IndexOperation.Builder().document(idAndObject.getValue()).id((String)idAndObject.getKey());
                operations.add(operation.build()._toBulkOperation());
            }
            this.prefixAwareOptimizeOpenSearchClient.doBulkRequest(() -> new BulkRequest.Builder().operations(operations).index(indexName), operations, "add entries", false);
        });
    }

    @Override
    public <T> List<T> getAllDocumentsOfIndexAs(String indexName, Class<T> type) {
        return this.getAllDocumentsOfIndexAs(indexName, type, QueryDSL.matchAll());
    }

    @Override
    public DatabaseClient getDatabaseClient() {
        return this.prefixAwareOptimizeOpenSearchClient;
    }

    @Override
    public Integer getDocumentCountOf(String indexName) {
        try {
            return Long.valueOf(this.getOptimizeOpenSearchClient().count(new String[]{indexName}, QueryDSL.matchAll())).intValue();
        }
        catch (IOException e) {
            throw new OptimizeIntegrationTestException("Cannot evaluate document count for index " + indexName, e);
        }
    }

    @Override
    public void deleteAllOptimizeData() {
        try {
            this.getOptimizeOpenSearchClient().deleteByQuery(QueryDSL.matchAll(), true, new String[]{this.getIndexNameService().getIndexPrefix() + "*"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deleteAllIndicesContainingTerm(String indexTerm) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().deleteIndicesWithRetries(new String[]{indexTerm + "*"});
    }

    @Override
    public void deleteAllSingleProcessReports() {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().deleteByQuery(QueryDSL.matchAll(), true, new String[]{this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new SingleProcessReportIndexOS())});
    }

    @Override
    public void deleteTerminatedSessionsIndex() {
        this.deleteIndexOfMapping((IndexMappingCreator<IndexSettings.Builder>)new TerminatedUserSessionIndexOS());
    }

    @Override
    public void deleteAllExternalVariableIndices() {
        String[] indexNames = (String[])this.getOptimizeOpenSearchClient().getAllIndicesForAlias(this.getIndexNameService().getOptimizeIndexAliasForIndex((IndexMappingCreator)new ExternalProcessVariableIndexOS())).toArray(String[]::new);
        this.deleteIndices(indexNames);
    }

    @Override
    public void deleteAllZeebeRecordsForPrefix(String zeebeRecordPrefix) {
        GetIndexResponse allIndices = this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().get(RequestDSL.getIndexRequestBuilder((String)"*").ignoreUnavailable(Boolean.valueOf(true)));
        String[] indicesToDelete = (String[])allIndices.result().keySet().stream().filter(indexName -> indexName.contains(zeebeRecordPrefix)).toArray(String[]::new);
        if (indicesToDelete.length > 1) {
            this.deleteIndices(indicesToDelete);
        }
    }

    @Override
    public void deleteAllOtherZeebeRecordsWithPrefix(String zeebeRecordPrefix, String recordsToKeep) {
        GetIndexResponse allIndices;
        try {
            allIndices = this.getOptimizeOpenSearchClient().getOpenSearchClient().indices().get(RequestDSL.getIndexRequestBuilder((String)"*").ignoreUnavailable(Boolean.valueOf(true)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] indicesToDelete = (String[])allIndices.result().keySet().stream().filter(indexName -> indexName.contains(zeebeRecordPrefix) && !indexName.contains(recordsToKeep)).toArray(String[]::new);
        if (indicesToDelete.length > 1) {
            this.deleteIndices(indicesToDelete);
        }
    }

    @Override
    public void updateZeebeRecordsForPrefix(String zeebeRecordPrefix, String indexName, String updateScript) {
        this.updateZeebeRecordsByQuery(zeebeRecordPrefix, indexName, QueryDSL.matchAll(), updateScript);
    }

    @Override
    public void updateZeebeRecordsWithPositionForPrefix(String zeebeRecordPrefix, String indexName, long position, String updateScript) {
        this.updateZeebeRecordsByQuery(zeebeRecordPrefix, indexName, QueryDSL.term((String)"position", (Long)position), updateScript);
    }

    @Override
    public void updateZeebeRecordsOfBpmnElementTypeForPrefix(String zeebeRecordPrefix, BpmnElementType bpmnElementType, String updateScript) {
        this.updateZeebeRecordsByQuery(zeebeRecordPrefix, "process-instance", QueryDSL.term((String)"value.bpmnElementType", (String)bpmnElementType.name()), updateScript);
    }

    @Override
    public void updateUserTaskDurations(String processInstanceId, String processDefinitionKey, long duration) {
        String updateScript = this.buildUpdateScript(duration);
        this.updateRecordsByQuery(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey), QueryDSL.ids((String[])new String[]{processInstanceId}), updateScript);
    }

    @Override
    public boolean indexExistsCheckWithApplyingOptimizePrefix(String indexOrAliasName) {
        return this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().indexExists(indexOrAliasName);
    }

    @Override
    public boolean indexExistsCheckWithoutApplyingOptimizePrefix(String indexName) {
        try {
            return this.getOptimizeOpenSearchClient().getOpenSearchClient().indices().exists(new ExistsRequest.Builder().index(indexName, new String[0]).build()).value();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public OffsetDateTime getLastImportTimestampOfTimestampBasedImportIndex(String dbType, String engine) {
        Optional response = this.prefixAwareOptimizeOpenSearchClient.getRichOpenSearchClient().doc().getRequest("timestamp-based-import-index", DatabaseHelper.constructKey((String)dbType, (String)engine), TimestampBasedImportIndexDto.class);
        return response.map(ImportIndexDto::getTimestampOfLastEntity).orElseThrow(() -> new OptimizeIntegrationTestException(String.format("Timestamp based import index does not exist: dbType: {%s}, engine: {%s}", dbType, engine)));
    }

    @Override
    public Map<AggregationDto, Double> calculateExpectedValueGivenDurations(Number ... setDuration) {
        return DurationAggregationUtil.calculateExpectedValueGivenDurationsWithPercentileInterpolation(setDuration);
    }

    @Override
    public long countRecordsByQuery(TermsQueryContainer queryContainer, String expectedIndex) {
        try {
            return this.getOptimizeOpenSearchClient().count(new String[]{expectedIndex}, queryContainer.toOpenSearchQuery().toQuery());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public <T> List<T> getZeebeExportedRecordsByQuery(String exportIndex, TermsQueryContainer queryForZeebeRecords, Class<T> zeebeRecordClass) {
        BoolQuery query = queryForZeebeRecords.toOpenSearchQuery();
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((String[])new String[0]).index(exportIndex, new String[0]).query(query.toQuery()).size(Integer.valueOf(100));
        try {
            return this.getOptimizeOpenSearchClient().getOpenSearchClient().search(searchRequest.build(), zeebeRecordClass).hits().hits().stream().map(Hit::source).toList();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void deleteProcessInstancesFromIndex(String indexName, String id) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().delete(indexName, id);
    }

    @Override
    public DatabaseType getDatabaseVendor() {
        return DatabaseType.OPENSEARCH;
    }

    @Override
    public void createSnapshot(String snapshotRepositoryName, String snapshotName, String[] indexNames) {
        CreateSnapshotRequest createSnapshotRequest = CreateSnapshotRequest.of(b -> b.repository(snapshotRepositoryName).snapshot(snapshotName).indices(Arrays.stream(indexNames).toList()).includeGlobalState(Boolean.valueOf(false)).waitForCompletion(Boolean.valueOf(true)));
        try {
            this.getOptimizeOpenSearchClient().triggerSnapshotAsync(createSnapshotRequest).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OptimizeRuntimeException("Exception during creation snapshot:", (Throwable)e);
        }
    }

    @Override
    public void createRepoSnapshot(String snapshotRepositoryName) {
        try {
            this.getOptimizeOpenSearchClient().getOpenSearchClient().snapshot().createRepository(CreateRepositoryRequest.of(b -> b.name(snapshotRepositoryName).settings(s -> s.location("/var/tmp")).type("fs")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanSnapshots(String snapshotRepositoryName) {
        try {
            this.getOptimizeOpenSearchClient().getOpenSearchClient().snapshot().delete(DeleteSnapshotRequest.of(b -> b.repository(snapshotRepositoryName).snapshot("*")));
            this.getOptimizeOpenSearchClient().getOpenSearchClient().snapshot().deleteRepository(DeleteRepositoryRequest.of(b -> b.name(snapshotRepositoryName, new String[0])));
        }
        catch (Exception e) {
            LOG.warn("Delete failed, no snapshots to delete from repository {}", (Object)snapshotRepositoryName);
        }
    }

    @Override
    public List<String> getImportIndices() {
        return OpenSearchSchemaManager.getAllNonDynamicMappings().stream().filter(IndexMappingCreator::isImportIndex).map(IndexMappingCreator::getIndexName).toList();
    }

    @Override
    protected <T extends OptimizeDto> List<T> getInstancesById(String indexName, List<String> instanceIds, String idField, Class<T> type) {
        return this.getAllDocumentsOfIndicesAs(new String[]{indexName}, type, QueryDSL.stringTerms((String)idField, instanceIds));
    }

    @Override
    public <T> Optional<T> getDatabaseEntryById(String indexName, String entryId, Class<T> type) {
        return Optional.ofNullable(this.getOptimizeOpenSearchClient().get(RequestDSL.getRequest((String)indexName, (String)entryId), type, "Could not retrieve entry from index " + indexName + " with id " + entryId).source());
    }

    @Override
    public String getDatabaseVersion() {
        if (this.opensearchDatabaseVersion == null) {
            try {
                this.opensearchDatabaseVersion = OpenSearchClientBuilder.getCurrentOSVersion((OpenSearchClient)this.getOptimizeOpenSearchClient().getOpenSearchClient());
            }
            catch (IOException e) {
                throw new OptimizeRuntimeException((Throwable)e);
            }
        }
        return this.opensearchDatabaseVersion;
    }

    @Override
    public int getNestedDocumentsLimit(ConfigurationService configurationService) {
        return configurationService.getOpenSearchConfiguration().getNestedDocumentsLimit();
    }

    @Override
    public void setNestedDocumentsLimit(ConfigurationService configurationService, int nestedDocumentsLimit) {
        configurationService.getOpenSearchConfiguration().setNestedDocumentsLimit(nestedDocumentsLimit);
    }

    @Override
    public void updateProcessInstanceNestedDocLimit(String processDefinitionKey, int nestedDocLimit, ConfigurationService configurationService) {
        this.setNestedDocumentsLimit(configurationService, nestedDocLimit);
        OptimizeOpenSearchClient osClient = this.getOptimizeOpenSearchClient();
        String indexName = osClient.getIndexNameService().getOptimizeIndexNameWithVersionForAllIndicesOf((IndexMappingCreator)new ProcessInstanceIndexOS(processDefinitionKey));
        try {
            osClient.getRichOpenSearchClient().index().putSettings(new PutIndicesSettingsRequest.Builder().settings(OpenSearchIndexSettingsBuilder.buildDynamicSettings((ConfigurationService)configurationService)).index(indexName, new String[0]).build());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Override
    public void createIndex(String optimizeIndexNameWithVersion, String optimizeIndexAliasForIndex) throws IOException {
        HashMap<String, Alias> aliasData = new HashMap<String, Alias>();
        aliasData.put(optimizeIndexAliasForIndex, new Alias.Builder().isWriteIndex(Boolean.valueOf(true)).build());
        CreateIndexRequest request = new CreateIndexRequest.Builder().index(optimizeIndexNameWithVersion).aliases(aliasData).build();
        boolean created = this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().createIndex(request);
        if (!created) {
            throw new IOException("Could not create index " + optimizeIndexNameWithVersion);
        }
    }

    @Override
    public void createIndex(String indexName, Map<String, Boolean> aliases, DefaultIndexMappingCreator indexMapping) throws IOException {
        IndexSettings indexSettings = this.createIndexSettings((IndexMappingCreator)indexMapping, this.createConfigurationService());
        HashMap<String, Alias> aliasData = new HashMap<String, Alias>();
        for (Map.Entry<String, Boolean> entry : aliases.entrySet()) {
            aliasData.put(entry.getKey(), new Alias.Builder().isWriteIndex(entry.getValue()).build());
        }
        indexMapping.setDynamic(DynamicMapping.False);
        CreateIndexRequest request = OpenSearchSchemaManager.createIndexFromJson((String)indexMapping.getSource().toString(), (String)indexName, aliasData, (IndexSettings)indexSettings);
        boolean created = this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().createIndex(request);
        if (!created) {
            throw new IOException("Could not create index " + indexName);
        }
    }

    @Override
    public Optional<MetadataDto> readMetadata() {
        return ((OpenSearchMetadataService)ApplicationContextProvider.getBean(OpenSearchMetadataService.class)).readMetadata(this.getOptimizeOpenSearchClient());
    }

    @Override
    public void setActivityStartDatesToNull(String processDefinitionKey, ScriptData script) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().updateByQuery(InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey), QueryDSL.matchAll(), QueryDSL.script((String)script.scriptString(), (Map)script.params()));
    }

    @Override
    public void setUserTaskDurationToNull(String processInstanceId, String durationFieldName, ScriptData script) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().updateByQuery("process-instance", QueryDSL.term((String)"processInstanceId", (String)processInstanceId), QueryDSL.script((String)script.scriptString(), (Map)script.params()));
    }

    @Override
    public Long getImportedActivityCount() {
        Aggregation subAggregation = AggregationDSL.valueCountAggregation((String)String.join((CharSequence)".", "flowNodeInstances", "flowNodeInstanceId"))._toAggregation();
        NestedAggregation termsAgg = new NestedAggregation.Builder().path("flowNodeInstances").build();
        Aggregation agg = AggregationDSL.withSubaggregations((NestedAggregation)termsAgg, Map.of("flowNodeInstances_frequency", subAggregation));
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index("process-instance", new String[0]).query(QueryDSL.matchAll()).size(Integer.valueOf(0)).aggregations(Map.of("flowNodeInstances", agg));
        SearchResponse searchResponse = this.getOptimizeOpenSearchClient().search(searchRequest, Aggregate.class, "Could not retrieve activity count from process instance indices.");
        Aggregate nested = (Aggregate)searchResponse.aggregations().get("flowNodeInstances");
        ValueCountAggregate countAggregator = ((Aggregate)nested.nested().aggregations().get("flowNodeInstances_frequency")).valueCount();
        return (long)countAggregator.value();
    }

    @Override
    public List<String> getAllIndicesWithWriteAlias(String aliasNameWithPrefix) {
        GetAliasResponse aliasResponse;
        try {
            aliasResponse = this.getOptimizeOpenSearchClient().getAlias(aliasNameWithPrefix);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        Map indexNameToAliasMap = aliasResponse.result();
        return indexNameToAliasMap.entrySet().stream().filter(entry -> ((IndexAliases)entry.getValue()).aliases().values().stream().anyMatch(alias -> alias.isWriteIndex() != null && alias.isWriteIndex() != false)).map(Map.Entry::getKey).toList();
    }

    @Override
    public void deleteAllDocumentsInIndex(String optimizeIndexAliasForIndex) {
        this.getOptimizeOpenSearchClient().deleteByQuery(QueryDSL.matchAll(), true, new String[]{optimizeIndexAliasForIndex});
    }

    @Override
    public void insertTestDocuments(int amount, String indexName, String jsonDocument) throws IOException {
        this.getOptimizeOpenSearchClient().getOpenSearchClient().bulk(BulkRequest.of(r -> {
            int i = 0;
            while (i < amount) {
                int finalI = i++;
                r.operations(o -> o.index(OptimizeIndexOperationOS.of(b -> {
                    try {
                        return b.optimizeIndex(this.getOptimizeOpenSearchClient(), indexName).document(this.getObjectMapper().readValue(String.format(jsonDocument, finalI), Map.class));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                })));
            }
            return r;
        }));
        this.getOptimizeOpenSearchClient().refresh(indexName);
    }

    @Override
    public void performLowLevelBulkRequest(String methodName, String endpoint, String bulkPayload) throws IOException {
        NStringEntity entity = new NStringEntity(bulkPayload, "application/json");
        Request request = new Request(methodName, endpoint);
        request.setEntity((HttpEntity)entity);
        this.getOptimizeOpenSearchClient().getRestClient().performRequest(request);
    }

    @Override
    public void initSchema(DatabaseSchemaManager schemaManager) {
        schemaManager.initializeSchema((DatabaseClient)this.getOptimizeOpenSearchClient());
    }

    @Override
    public Map<String, ? extends Object> getMappingFields(String indexName) throws IOException {
        GetMappingResponse getMappingResponse = this.getOptimizeOpenSearchClient().getMapping(new GetMappingRequest.Builder(), new String[]{indexName});
        Map propertiesMap = ((IndexMappingRecord)getMappingResponse.result().values().stream().findFirst().orElseThrow(() -> new OptimizeRuntimeException("There should be at least one mapping available for the index!"))).mappings().properties();
        if (propertiesMap instanceof Map) {
            return propertiesMap;
        }
        throw new OptimizeRuntimeException("Database index mapping properties should be of type map");
    }

    @Override
    public boolean indexExists(String indexOrAliasName, Boolean addMappingFeatures) {
        return this.indexExists(indexOrAliasName);
    }

    @Override
    public boolean templateExists(String optimizeIndexTemplateNameWithVersion) throws IOException {
        ExistsTemplateRequest.Builder request = new ExistsTemplateRequest.Builder().name(optimizeIndexTemplateNameWithVersion, new String[0]);
        return this.getOptimizeOpenSearchClient().getOpenSearchClient().indices().existsTemplate(request.build()).value();
    }

    @Override
    public boolean isAliasReadOnly(String readOnlyAliasForIndex) throws IOException {
        GetAliasResponse aliases = this.getOptimizeOpenSearchClient().getAlias(GetAliasRequest.of(a -> a.name(this.getOptimizeOpenSearchClient().applyIndexPrefixes(new String[]{readOnlyAliasForIndex}))));
        return aliases.result().values().stream().flatMap(a -> a.aliases().values().stream()).collect(Collectors.toSet()).stream().noneMatch(AliasDefinition::isWriteIndex);
    }

    @Override
    public List<String> getAllIndicesWithReadOnlyAlias(String aliasNameWithPrefix) {
        GetAliasResponse aliasResponse;
        try {
            aliasResponse = this.getOptimizeOpenSearchClient().getAlias(aliasNameWithPrefix);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
        Map indexNameToAliasMap = aliasResponse.result();
        return indexNameToAliasMap.entrySet().stream().filter(entry -> ((IndexAliases)entry.getValue()).aliases().values().stream().anyMatch(alias -> alias.isWriteIndex() != null && alias.isWriteIndex() == false)).map(Map.Entry::getKey).toList();
    }

    @Override
    public String[] getIndexNames() throws IOException {
        return this.getOptimizeOpenSearchClient().getAllIndexNames().toArray(new String[0]);
    }

    private IndexSettings createIndexSettings(IndexMappingCreator indexMappingCreator, ConfigurationService configurationService) {
        try {
            return OpenSearchIndexSettingsBuilder.buildAllSettings((ConfigurationService)configurationService, (IndexMappingCreator)indexMappingCreator);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not create index settings");
        }
    }

    public boolean indexExists(String indexOrAliasName) {
        return this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().indexExists(indexOrAliasName);
    }

    private OptimizeOpenSearchClient getOptimizeOpenSearchClient() {
        return this.prefixAwareOptimizeOpenSearchClient;
    }

    private void initOsClient() {
        if (CLIENT_CACHE.containsKey(this.customIndexPrefix)) {
            this.prefixAwareOptimizeOpenSearchClient = CLIENT_CACHE.get(this.customIndexPrefix);
        } else {
            this.createClientAndAddToCache(this.customIndexPrefix, this.createConfigurationService());
        }
    }

    private void createClientAndAddToCache(String clientKey, ConfigurationService configurationService) {
        DatabaseConnectionNodeConfiguration osConfig = configurationService.getOpenSearchConfiguration().getFirstConnectionNode();
        LOG.info("Creating OS Client with host {} and port {}", (Object)osConfig.getHost(), (Object)osConfig.getHttpPort());
        this.prefixAwareOptimizeOpenSearchClient = new OptimizeOpenSearchClient(OpenSearchClientBuilder.restClient((ConfigurationService)configurationService), OpenSearchClientBuilder.buildOpenSearchClientFromConfig((ConfigurationService)configurationService, (PluginRepository)new PluginRepository()), OpenSearchClientBuilder.buildOpenSearchAsyncClientFromConfig((ConfigurationService)configurationService, (PluginRepository)new PluginRepository()), new OptimizeIndexNameService(configurationService, DatabaseType.OPENSEARCH), new TransportOptionsProvider());
        this.adjustClusterSettings();
        CLIENT_CACHE.put(clientKey, this.prefixAwareOptimizeOpenSearchClient);
    }

    private ConfigurationService createConfigurationService() {
        ConfigurationService configurationService = IntegrationTestConfigurationUtil.createItConfigurationService();
        if (this.customIndexPrefix != null) {
            configurationService.getOpenSearchConfiguration().setIndexPrefix(configurationService.getOpenSearchConfiguration().getIndexPrefix() + this.customIndexPrefix);
        }
        return configurationService;
    }

    private void adjustClusterSettings() {
        PutClusterSettingsRequest.Builder settings = new PutClusterSettingsRequest.Builder().persistent("action.auto_create_index", JsonData.of((Object)true)).persistent("cluster.max_shards_per_node", JsonData.of((Object)10000)).flatSettings(Boolean.valueOf(true));
        try {
            this.getOptimizeOpenSearchClient().getOpenSearchClient().cluster().putSettings(settings.build());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not update cluster settings!", (Throwable)e);
        }
    }

    private <T> List<T> getAllDocumentsOfIndexAs(String indexName, Class<T> type, Query query) {
        return this.getAllDocumentsOfIndicesAs(new String[]{indexName}, type, query);
    }

    private OptimizeIndexNameService getIndexNameService() {
        return this.getOptimizeOpenSearchClient().getIndexNameService();
    }

    private <T> List<T> getAllDocumentsOfIndicesAs(String[] indexNames, Class<T> type, Query query) {
        SearchRequest.Builder searchReqBuilder = RequestDSL.searchRequestBuilder((String[])new String[0]).index(List.of(indexNames)).query(query).trackTotalHits((TrackHits)new TrackHits.Builder().enabled(Boolean.valueOf(true)).build()).size(Integer.valueOf(100));
        String errorMessage = "Was not able to retrieve all documents for indices";
        SearchResponse searchResponse = this.getOptimizeOpenSearchClient().search(searchReqBuilder, type, "Was not able to retrieve all documents for indices");
        return searchResponse.hits().hits().stream().map(Hit::source).collect(Collectors.toList());
    }

    private void deleteIndexOfMapping(IndexMappingCreator<IndexSettings.Builder> indexMapping) {
        this.deleteIndices(new String[]{indexMapping.getIndexName()});
    }

    private void deleteIndices(String[] indicesToDelete) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().index().deleteIndicesWithRetries(indicesToDelete);
    }

    private void updateZeebeRecordsByQuery(String zeebeRecordPrefix, String indexName, Query query, String updateScript) {
        this.updateRecordsByQuery(zeebeRecordPrefix + "_" + indexName + "*", query, updateScript);
    }

    private void updateRecordsByQuery(String indexName, Query query, String updateScript) {
        this.getOptimizeOpenSearchClient().getRichOpenSearchClient().doc().updateByQuery(indexName, query, OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams((String)updateScript, Collections.emptyMap()));
    }
}

