/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.client.api.worker.JobWorker;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.test.it.extension.ClockActuatorClient;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.containers.ZeebeContainer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.Testcontainers;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class ZeebeExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final String ZEEBE_CONFIG_PATH = "zeebe/zeebe-application.yml";
    private static final String ZEEBE_VERSION = IntegrationTestConfigurationUtil.getZeebeDockerVersion();
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeExtension.class);
    private ZeebeContainer zeebeContainer;
    private CamundaClient camundaClient;
    private String zeebeRecordPrefix;

    public ZeebeExtension() {
        String zeebeExporterClassName;
        int databasePort;
        if (IntegrationTestConfigurationUtil.getDatabaseType().equals((Object)DatabaseType.OPENSEARCH)) {
            databasePort = 9200;
            zeebeExporterClassName = "io.camunda.zeebe.exporter.opensearch.OpensearchExporter";
        } else {
            databasePort = 9200;
            zeebeExporterClassName = "io.camunda.zeebe.exporter.ElasticsearchExporter";
        }
        Testcontainers.exposeHostPorts((int[])new int[]{databasePort});
        this.zeebeContainer = (ZeebeContainer)((ZeebeContainer)((ZeebeContainer)((ZeebeContainer)new ZeebeContainer(DockerImageName.parse((String)("camunda/zeebe:" + ZEEBE_VERSION))).withEnv("ZEEBE_CLOCK_CONTROLLED", "true")).withEnv("DATABASE_PORT", String.valueOf(databasePort))).withEnv("ZEEBE_EXPORTER_CLASS_NAME", zeebeExporterClassName)).withCopyFileToContainer(MountableFile.forClasspathResource((String)ZEEBE_CONFIG_PATH), "/usr/local/zeebe/config/application.yml");
        if (!AbstractCCSMIT.isZeebeVersionPre85()) {
            this.zeebeContainer = (ZeebeContainer)((ZeebeContainer)this.zeebeContainer.withEnv("ZEEBE_BROKER_GATEWAY_ENABLE", "true")).withAdditionalExposedPort(8080);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.zeebeRecordPrefix = "zeebe-record-" + IdGenerator.getNextId();
        this.setZeebeRecordPrefixForTest();
        this.zeebeContainer.start();
        this.createClient();
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.zeebeContainer.stop();
        this.destroyClient();
    }

    public void createClient() {
        this.camundaClient = AbstractCCSMIT.isZeebeVersionPre85() ? CamundaClient.newClientBuilder().defaultRequestTimeout(Duration.ofMillis(15000L)).grpcAddress(this.zeebeContainer.getGrpcAddress()).build() : CamundaClient.newClientBuilder().defaultRequestTimeout(Duration.ofMillis(15000L)).grpcAddress(this.zeebeContainer.getGrpcAddress()).restAddress(this.zeebeContainer.getRestAddress()).build();
    }

    public Process deployProcess(BpmnModelInstance bpmnModelInstance) {
        DeployResourceCommandStep1 deployResourceCommandStep1 = this.camundaClient.newDeployResourceCommand();
        deployResourceCommandStep1.addProcessModel(bpmnModelInstance, "resourceName.bpmn");
        DeploymentEvent deploymentEvent = (DeploymentEvent)((DeployResourceCommandStep1.DeployResourceCommandStep2)deployResourceCommandStep1).send().join();
        return (Process)deploymentEvent.getProcesses().get(0);
    }

    public long startProcessInstanceWithVariables(String bpmnProcessId, Map<String, Object> variables) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = this.camundaClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion().variables(variables);
        return ((ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join()).getProcessInstanceKey();
    }

    public void startProcessInstanceWithSignal(String signalName) {
        this.broadcastSignalWithName(signalName);
    }

    public void broadcastSignalWithName(String signalName) {
        this.camundaClient.newBroadcastSignalCommand().signalName(signalName).send().join();
    }

    public void startProcessInstanceBeforeElementWithIds(String bpmnProcessId, String ... elementIds) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstanceCommandStep3 = this.camundaClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion();
        for (String elementId : elementIds) {
            createProcessInstanceCommandStep3.startBeforeElement(elementId);
        }
        ((ProcessInstanceEvent)createProcessInstanceCommandStep3.send().join()).getProcessInstanceKey();
    }

    public void addVariablesToScope(Long variableScopeKey, Map<String, Object> variables, boolean local) {
        this.camundaClient.newSetVariablesCommand(variableScopeKey.longValue()).variables(variables).local(local).send().join();
    }

    public void setClock(Instant pinAt) throws IOException, InterruptedException {
        ClockActuatorClient clockClient = new ClockActuatorClient(this.zeebeContainer.getExternalMonitoringAddress());
        clockClient.pinZeebeTime(pinAt);
    }

    public ProcessInstanceEvent startProcessInstanceForProcess(String processId) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 startInstanceCommand = this.camundaClient.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion();
        return (ProcessInstanceEvent)startInstanceCommand.send().join();
    }

    public void cancelProcessInstance(long processInstanceKey) {
        this.camundaClient.newCancelInstanceCommand(processInstanceKey).send().join();
    }

    public void completeTaskForInstanceWithJobType(String jobType) {
        this.completeTaskForInstanceWithJobType(jobType, null);
    }

    public void completeTaskForInstanceWithJobType(String jobType, Map<String, Object> variables) {
        this.handleSingleJob(jobType, (camundaClient, job) -> {
            CompleteJobCommandStep1 completeJobCommandStep1 = camundaClient.newCompleteCommand(job.getKey());
            Optional.ofNullable(variables).ifPresent(arg_0 -> ((CompleteJobCommandStep1)completeJobCommandStep1).variables(arg_0));
            completeJobCommandStep1.send().join();
        });
    }

    public void completeZeebeUserTask(long userTaskKey) {
        this.camundaClient.newCompleteUserTaskCommand(userTaskKey).send().join();
    }

    public void assignUserTask(long userTaskKey, String assigneeId) {
        this.camundaClient.newAssignUserTaskCommand(userTaskKey).assignee(assigneeId).send().join();
    }

    public void unassignUserTask(long userTaskKey) {
        this.camundaClient.newUnassignUserTaskCommand(userTaskKey).send().join();
    }

    public void updateCandidateGroupForUserTask(long userTaskKey, String candidateGroup) {
        this.camundaClient.newUpdateUserTaskCommand(userTaskKey).candidateGroups(new String[]{candidateGroup}).send().join();
    }

    public void throwErrorIncident(String jobType) {
        this.handleSingleJob(jobType, (camundaClient, job) -> camundaClient.newThrowErrorCommand(job.getKey()).errorCode("1").errorMessage("someErrorMessage").send().join());
    }

    public void failTask(String jobType) {
        this.handleSingleJob(jobType, (camundaClient, job) -> camundaClient.newFailCommand(job.getKey()).retries(0).errorMessage("someTaskFailMessage").send().join());
    }

    public void resolveIncident(Long incidentKey) {
        this.camundaClient.newResolveIncidentCommand(incidentKey.longValue()).send().join();
    }

    public String getZeebeRecordPrefix() {
        return this.zeebeRecordPrefix;
    }

    private void handleSingleJob(String jobType, JobHandler jobHandler) {
        AtomicBoolean jobCompleted = new AtomicBoolean(false);
        JobWorker jobWorker = this.camundaClient.newWorker().jobType(jobType).handler((camundaClient, type) -> {
            if (jobCompleted.compareAndSet(false, true)) {
                jobHandler.handle(camundaClient, type);
            } else {
                camundaClient.newFailCommand(type.getKey()).retries(type.getRetries()).errorMessage("skip job handling, already handled in this way").send().join();
            }
        }).timeout(Duration.ofSeconds(2L)).open();
        Awaitility.await().timeout(10L, TimeUnit.SECONDS).untilTrue(jobCompleted);
        jobWorker.close();
    }

    private void setZeebeRecordPrefixForTest() {
        this.zeebeContainer = (ZeebeContainer)this.zeebeContainer.withEnv("ZEEBE_BROKER_EXPORTERS_OPTIMIZE_ARGS_INDEX_PREFIX", this.zeebeRecordPrefix);
    }

    private void destroyClient() {
        if (this.camundaClient != null) {
            this.camundaClient.close();
            this.camundaClient = null;
        }
    }
}

