/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.test.it.extension;

import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.service.db.schema.DatabaseSchemaManager;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.DatabaseType;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.test.it.extension.db.DatabaseTestService;
import io.camunda.optimize.test.it.extension.db.ElasticsearchDatabaseTestService;
import io.camunda.optimize.test.it.extension.db.OpenSearchDatabaseTestService;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockserver.integration.ClientAndServer;

public class DatabaseIntegrationTestExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final DatabaseTestService databaseTestService;

    public DatabaseIntegrationTestExtension(DatabaseType databaseType) {
        this(null, true, databaseType);
    }

    public DatabaseIntegrationTestExtension() {
        this(true);
    }

    public DatabaseIntegrationTestExtension(boolean haveToClean) {
        this(null, haveToClean);
    }

    private DatabaseIntegrationTestExtension(String customIndexPrefix, boolean haveToClean) {
        this(customIndexPrefix, haveToClean, IntegrationTestConfigurationUtil.getDatabaseType());
    }

    private DatabaseIntegrationTestExtension(String customIndexPrefix, boolean haveToClean, DatabaseType databaseType) {
        this.databaseTestService = databaseType == null || databaseType.equals((Object)DatabaseType.ELASTICSEARCH) ? new ElasticsearchDatabaseTestService(customIndexPrefix, haveToClean) : new OpenSearchDatabaseTestService(customIndexPrefix, haveToClean);
    }

    public void cleanSnapshots(String snapshotRepositoryName) {
        this.databaseTestService.cleanSnapshots(snapshotRepositoryName);
    }

    public void createRepoSnapshot(String snapshotRepositoryName) {
        this.databaseTestService.createRepoSnapshot(snapshotRepositoryName);
    }

    public void createSnapshot(String snapshotRepositoryName, String snapshotName, String[] indexNames) {
        this.databaseTestService.createSnapshot(snapshotRepositoryName, snapshotName, indexNames);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.databaseTestService.beforeEach();
    }

    public void afterEach(ExtensionContext context) {
        this.databaseTestService.afterEach();
    }

    public ClientAndServer useDbMockServer() {
        return this.databaseTestService.useDBMockServer();
    }

    public void refreshAllOptimizeIndices() {
        this.databaseTestService.refreshAllOptimizeIndices();
    }

    public <T> List<T> getAllDocumentsOfIndexAs(String indexName, Class<T> type) {
        return this.databaseTestService.getAllDocumentsOfIndexAs(indexName, type);
    }

    public OptimizeIndexNameService getIndexNameService() {
        return this.databaseTestService.getDatabaseClient().getIndexNameService();
    }

    public boolean indexExists(String indexOrAliasName) {
        return this.databaseTestService.indexExistsCheckWithApplyingOptimizePrefix(indexOrAliasName);
    }

    public List<ProcessDefinitionOptimizeDto> getAllProcessDefinitions() {
        return this.getAllDocumentsOfIndexAs("process-definition", ProcessDefinitionOptimizeDto.class);
    }

    public List<ProcessInstanceDto> getAllProcessInstances() {
        return this.getAllDocumentsOfIndexAs("process-instance", ProcessInstanceDto.class);
    }

    public void deleteAllZeebeRecordsForPrefix(String zeebeRecordPrefix) {
        this.databaseTestService.deleteAllZeebeRecordsForPrefix(zeebeRecordPrefix);
    }

    public void deleteAllOtherZeebeRecordsWithPrefix(String zeebeRecordPrefix, String recordsToKeep) {
        this.databaseTestService.deleteAllOtherZeebeRecordsWithPrefix(zeebeRecordPrefix, recordsToKeep);
    }

    public void updateZeebeRecordsWithPositionForPrefix(String zeebeRecordPrefix, String indexName, long position, String updateScript) {
        this.databaseTestService.updateZeebeRecordsWithPositionForPrefix(zeebeRecordPrefix, indexName, position, updateScript);
    }

    public void updateZeebeProcessRecordsOfBpmnElementTypeForPrefix(String zeebeRecordPrefix, BpmnElementType bpmnElementType, String updateScript) {
        this.databaseTestService.updateZeebeRecordsOfBpmnElementTypeForPrefix(zeebeRecordPrefix, bpmnElementType, updateScript);
    }

    public void updateZeebeRecordsForPrefix(String zeebeRecordPrefix, String indexName, String updateScript) {
        this.databaseTestService.updateZeebeRecordsForPrefix(zeebeRecordPrefix, indexName, updateScript);
    }

    public void update(String indexName, String entityId, ScriptData script) {
        this.databaseTestService.getDatabaseClient().update(indexName, entityId, script);
    }

    public long countRecordsByQuery(TermsQueryContainer queryContainer, String index) {
        return this.databaseTestService.countRecordsByQuery(queryContainer, index);
    }

    public List<String> getAllIndicesWithReadOnlyAlias(String externalProcessVariableIndexName) {
        String aliasNameWithPrefix = this.getIndexNameService().getOptimizeIndexAliasForIndex(externalProcessVariableIndexName);
        return this.databaseTestService.getAllIndicesWithReadOnlyAlias(aliasNameWithPrefix);
    }

    public <T> List<T> getZeebeExportedRecordsByQuery(String exportIndex, TermsQueryContainer query, Class<T> zeebeRecordClass) {
        return this.databaseTestService.getZeebeExportedRecordsByQuery(exportIndex, query, zeebeRecordClass);
    }

    public boolean zeebeIndexExists(String expectedIndex) {
        return this.databaseTestService.indexExistsCheckWithoutApplyingOptimizePrefix(expectedIndex);
    }

    public <T> Optional<T> getDatabaseEntryById(String indexName, String entryId, Class<T> type) {
        return this.databaseTestService.getDatabaseEntryById(indexName, entryId, type);
    }

    public DatabaseType getDatabaseVendor() {
        return this.databaseTestService.getDatabaseVendor();
    }

    public void updateProcessInstanceNestedDocLimit(String processDefinitionKey, int nestedDocLimit, ConfigurationService configurationService) {
        this.databaseTestService.updateProcessInstanceNestedDocLimit(processDefinitionKey, nestedDocLimit, configurationService);
    }

    public void createIndex(String optimizeIndexNameWithVersion, String optimizeIndexAliasForIndex, DefaultIndexMappingCreator mapping) throws IOException {
        this.createIndex(optimizeIndexNameWithVersion, optimizeIndexAliasForIndex, mapping, true);
    }

    public List<String> getAllIndicesWithWriteAlias(String indexName) {
        String aliasNameWithPrefix = this.getIndexNameService().getOptimizeIndexAliasForIndex(indexName);
        return this.databaseTestService.getAllIndicesWithWriteAlias(aliasNameWithPrefix);
    }

    public void deleteAllDocumentsInIndex(String optimizeIndexAliasForIndex) {
        this.databaseTestService.deleteAllDocumentsInIndex(optimizeIndexAliasForIndex);
    }

    public void insertTestDocuments(int amount, String indexName, String documentContentAsJson) throws IOException {
        this.databaseTestService.insertTestDocuments(amount, indexName, documentContentAsJson);
    }

    public void performLowLevelBulkRequest(String methodName, String endpoint, String bulkPayload) throws IOException {
        this.databaseTestService.performLowLevelBulkRequest(methodName, endpoint, bulkPayload);
    }

    public void initSchema(DatabaseSchemaManager schemaManager) {
        this.databaseTestService.initSchema(schemaManager);
    }

    public Map<String, ?> getMappingFields(String indexName) throws IOException {
        return this.databaseTestService.getMappingFields(indexName);
    }

    public boolean indexExists(String versionedIndexName, Boolean addMappingFeatures) {
        return this.databaseTestService.indexExists(versionedIndexName, addMappingFeatures);
    }

    public void createIndex(String optimizeIndexNameWithVersion, String optimizeIndexAliasForIndex, DefaultIndexMappingCreator mapping, Boolean isWriteIndex) throws IOException {
        this.createIndex(optimizeIndexNameWithVersion, Map.of(optimizeIndexAliasForIndex, isWriteIndex), mapping);
    }

    public void createIndex(String optimizeIndexNameWithVersion, Map<String, Boolean> aliases, DefaultIndexMappingCreator mapping) throws IOException {
        this.databaseTestService.createIndex(optimizeIndexNameWithVersion, aliases, mapping);
    }

    public boolean templateExists(String optimizeIndexTemplateNameWithVersion) throws IOException {
        return this.databaseTestService.templateExists(optimizeIndexTemplateNameWithVersion);
    }

    public boolean isAliasReadOnly(String readOnlyAliasForIndex) throws IOException {
        return this.databaseTestService.isAliasReadOnly(readOnlyAliasForIndex);
    }

    public String[] getIndexNames() throws IOException {
        return this.databaseTestService.getIndexNames();
    }
}

