/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.instance.FixedDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.InstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.IdentityLinkFilterDataDto;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.util.ValidationHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValidationHelperTest {
    @Test
    void shouldBeSuccessfullyValidatedWhenDtoHasValidFieldValues() {
        BranchAnalysisRequestDto dto = new BranchAnalysisRequestDto();
        dto.setFilter(List.of(new AssigneeFilterDto(new IdentityLinkFilterDataDto(MembershipFilterOperator.IN, List.of()))));
        dto.setEnd("3");
        dto.setGateway("3");
        dto.setProcessDefinitionKey("3");
        dto.setProcessDefinitionVersion("3");
        ValidationHelper.validate((BranchAnalysisRequestDto)dto);
    }

    @Test
    void shouldThrowExceptionWhenDtoIsInvalid() {
        BranchAnalysisRequestDto dto = new BranchAnalysisRequestDto();
        Throwable thrown = Assertions.catchThrowable(() -> ValidationHelper.validate((BranchAnalysisRequestDto)dto));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(OptimizeValidationException.class)).hasMessageContaining("gateway activity id is not allowed to be empty or null");
    }

    @Test
    void shouldThrowExceptionWhenTargetIsNull() {
        String fieldName = "testField";
        Object target = null;
        Throwable thrown = Assertions.catchThrowable(() -> ValidationHelper.ensureNotEmpty((String)"testField", (Object)target));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(OptimizeValidationException.class)).hasMessageContaining("testField is not allowed to be empty or null");
    }

    @Test
    void shouldThrowExceptionWhenCollectionIsEmpty() {
        String fieldName = "testCollection";
        List collection = Collections.emptyList();
        Throwable thrown = Assertions.catchThrowable(() -> ValidationHelper.ensureCollectionNotEmpty((String)"testCollection", (Collection)collection));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(OptimizeValidationException.class)).hasMessageContaining("testCollection is not allowed to be empty or null");
    }

    @Test
    void shouldValidateFiltersCorrectly() {
        InstanceStartDateFilterDto validFilter = new InstanceStartDateFilterDto();
        validFilter.setFilterLevel(FilterApplicationLevel.INSTANCE);
        validFilter.setData((FilterDataDto)new FixedDateFilterDataDto(null, null));
        Throwable thrown = Assertions.catchThrowable(() -> ValidationHelperTest.lambda$shouldValidateFiltersCorrectly$3((ProcessFilterDto)validFilter));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(OptimizeValidationException.class)).hasMessageContaining("start date filter  at least one sub field not allowed to be empty or null");
    }

    @Test
    void shouldThrowExceptionWhenAggregationIsInvalid() {
        AggregationDto invalidAggregation = new AggregationDto();
        invalidAggregation.setType(AggregationType.PERCENTILE);
        invalidAggregation.setValue(Double.valueOf(150.0));
        Throwable thrown = Assertions.catchThrowable(() -> ValidationHelper.validateAggregationTypes(Set.of(invalidAggregation)));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thrown).isInstanceOf(OptimizeValidationException.class)).hasMessageContaining("Percentile aggregation values be between 0 and 100");
    }

    @Test
    void shouldReturnFalseForInvalidDto() {
        ReportDataDto invalidDto = null;
        boolean result = ValidationHelper.isValid(invalidDto);
        Assertions.assertThat((boolean)result).isFalse();
    }

    private static /* synthetic */ void lambda$shouldValidateFiltersCorrectly$3(ProcessFilterDto validFilter) throws Throwable {
        ValidationHelper.validateProcessFilters(List.of(validFilter));
    }
}

