/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.DurationFormatterUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

public class DurationFormatterUtilTest {
    @Test
    void shouldReturnReadableStringForDurationInMilliseconds() {
        long durationInMs = 4000000000L;
        String result = DurationFormatterUtil.formatMilliSecondsToReadableDurationString((long)4000000000L);
        Assertions.assertThat((String)result).isEqualTo("1mo 2wks 2d 7h 6min 40s");
    }

    @ParameterizedTest
    @ValueSource(ints={0, -1000})
    void shouldReturnDashForZeroOrNegativeDuration(int durationInMs) {
        String result = DurationFormatterUtil.formatMilliSecondsToReadableDurationString((long)durationInMs);
        Assertions.assertThat((String)result).isEqualTo("-");
    }

    @Test
    void shouldFormatWithMillisecondsRemaining() {
        long durationInMs = 1234567L;
        String result = DurationFormatterUtil.formatMilliSecondsToReadableDurationString((long)1234567L);
        Assertions.assertThat((String)result).isEqualTo("20min 34s 567ms");
    }

    @Test
    void shouldHandleLargeDurationsIncludingYearsAndMonths() {
        long durationInMs = 34819200000L;
        String result = DurationFormatterUtil.formatMilliSecondsToReadableDurationString((long)34819200000L);
        Assertions.assertThat((String)result).isEqualTo("1yrs 1mo 1wks 1d");
    }

    @ParameterizedTest
    @CsvSource(value={"15,15min", "0,''"})
    void shouldFormatDurationStringCorrectly(int duration, String expected) {
        String unitString = "min";
        String result = DurationFormatterUtil.formatDuration((String)"min", (long)duration);
        Assertions.assertThat((String)result).isEqualTo(expected);
    }
}

