/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import io.camunda.optimize.service.util.DataUtil;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataUtilTest {
    @Test
    public void shouldReturnHashSetWithMultipleElements() {
        HashSet result = DataUtil.newHashSet((Object[])new String[]{"apple", "banana", "cherry"});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).hasSize(3)).contains((Object[])new String[]{"apple", "banana", "cherry"});
    }

    @Test
    public void shouldDeduplicateDuplicateElements() {
        HashSet result = DataUtil.newHashSet((Object[])new String[]{"apple", "banana", "apple", "cherry", "banana"});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).hasSize(3)).contains((Object[])new String[]{"apple", "banana", "cherry"});
    }

    @Test
    public void shouldReturnEmptyHashSet() {
        HashSet result = DataUtil.newHashSet((Object[])new String[0]);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).isEmpty();
    }

    @Test
    public void shouldReturnHashSetWithSingleElement() {
        HashSet result = DataUtil.newHashSet((Object[])new String[]{"apple"});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)result).isNotNull()).hasSize(1)).contains((Object[])new String[]{"apple"});
    }

    @Test
    public void shouldThrowExceptionForNullArray() {
        Assertions.assertThatThrownBy(() -> DataUtil.newHashSet((Object[])null)).isInstanceOf(NullPointerException.class);
    }
}

