/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.tenant;

import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.security.util.tenant.CamundaCCSMTenantAuthorizationService;
import io.camunda.optimize.service.util.configuration.CacheConfiguration;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.GlobalCacheConfiguration;
import io.camunda.optimize.service.util.importing.ZeebeConstants;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class CCSMTenantAuthorizationServiceTest {
    private static final String TEST_TOKEN = "someAuthToken";
    private static final String TEST_USER_ID = "someUserId";
    @Mock
    private CCSMTokenService ccsmTokenService;
    @Mock
    private ConfigurationService configurationService;
    private CamundaCCSMTenantAuthorizationService underTest;

    @BeforeEach
    public void beforeEach() {
        Mockito.when((Object)this.configurationService.isMultiTenancyEnabled()).thenReturn((Object)true);
        CacheConfiguration tenantCacheConfig = new CacheConfiguration();
        tenantCacheConfig.setMaxSize(10);
        tenantCacheConfig.setDefaultTtlMillis(10000);
        GlobalCacheConfiguration cacheConfig = new GlobalCacheConfiguration();
        cacheConfig.setCloudTenantAuthorizations(tenantCacheConfig);
        Mockito.when((Object)this.configurationService.getCaches()).thenReturn((Object)cacheConfig);
        Mockito.when((Object)this.ccsmTokenService.getCurrentUserIdFromAuthToken()).thenReturn(Optional.of(TEST_USER_ID));
        Mockito.when((Object)this.ccsmTokenService.getCurrentUserAuthToken()).thenReturn(Optional.of(TEST_TOKEN));
        this.underTest = new CamundaCCSMTenantAuthorizationService(this.ccsmTokenService, this.configurationService);
    }

    @Test
    public void usersAuthorizedToDefaultTenantWhenMultiTenancyDisabled() {
        Mockito.when((Object)this.configurationService.isMultiTenancyEnabled()).thenReturn((Object)false);
        List actualAuthorizedTenants = this.underTest.getCurrentUserAuthorizedTenants();
        ((CCSMTokenService)Mockito.verify((Object)this.ccsmTokenService, (VerificationMode)Mockito.never())).getAuthorizedTenantsFromToken((String)ArgumentMatchers.any());
        ((ObjectAssert)Assertions.assertThat((List)actualAuthorizedTenants).singleElement()).isEqualTo((Object)ZeebeConstants.ZEEBE_DEFAULT_TENANT);
        this.assertTenantAuthorization("<default>");
        this.assertNoTenantAuthorization("unauthorizedTenantId");
        this.assertTenantAuthorization(List.of("<default>"));
        this.assertNoTenantAuthorization(List.of("unauthorizedTenantId"));
        this.assertNoTenantAuthorization(List.of("<default>", "unauthorizedTenantId"));
    }

    @Test
    public void usersAuthorizedToTenantsRetrievedFromIdentity() {
        List<TenantDto> authorizedTenants = List.of(new TenantDto("tenant1Id", "tenant1", "zeebe"), new TenantDto("tenant2Id", "tenant2", "zeebe"));
        Mockito.when((Object)this.ccsmTokenService.getAuthorizedTenantsFromToken(TEST_TOKEN)).thenReturn(authorizedTenants);
        List actualAuthorizedTenants = this.underTest.getCurrentUserAuthorizedTenants();
        ((CCSMTokenService)Mockito.verify((Object)this.ccsmTokenService, (VerificationMode)Mockito.times((int)1))).getAuthorizedTenantsFromToken(TEST_TOKEN);
        Assertions.assertThat((List)actualAuthorizedTenants).containsExactlyInAnyOrderElementsOf(authorizedTenants);
        this.assertTenantAuthorization("tenant1Id");
        this.assertNoTenantAuthorization("unauthorizedTenantId");
        this.assertTenantAuthorization(authorizedTenants.stream().map(TenantDto::getId).toList());
        this.assertNoTenantAuthorization(List.of("tenant3", "tenant4"));
        this.assertNoTenantAuthorization(List.of("tenant1Id", "tenant3", "tenant4"));
    }

    @Test
    public void tenantAuthorizationCacheIsUsed() {
        List<TenantDto> authorizedTenants = List.of(new TenantDto("tenant1Id", "tenant1", "zeebe"), new TenantDto("tenant2Id", "tenant2", "zeebe"));
        Mockito.when((Object)this.ccsmTokenService.getAuthorizedTenantsFromToken(TEST_TOKEN)).thenReturn(authorizedTenants);
        List actualAuthorizedTenants = this.underTest.getCurrentUserAuthorizedTenants();
        ((CCSMTokenService)Mockito.verify((Object)this.ccsmTokenService, (VerificationMode)Mockito.times((int)1))).getAuthorizedTenantsFromToken(TEST_TOKEN);
        Assertions.assertThat((List)actualAuthorizedTenants).containsExactlyInAnyOrderElementsOf(authorizedTenants);
        actualAuthorizedTenants = this.underTest.getCurrentUserAuthorizedTenants();
        ((CCSMTokenService)Mockito.verify((Object)this.ccsmTokenService, (VerificationMode)Mockito.times((int)1))).getAuthorizedTenantsFromToken(TEST_TOKEN);
        Assertions.assertThat((List)actualAuthorizedTenants).containsExactlyInAnyOrderElementsOf(authorizedTenants);
    }

    @Test
    public void noTenantAuthorizationsReturnedIfNoUserTokenPresent() {
        Mockito.when((Object)this.ccsmTokenService.getCurrentUserIdFromAuthToken()).thenReturn(Optional.empty());
        List actualAuthorizedTenants = this.underTest.getCurrentUserAuthorizedTenants();
        ((CCSMTokenService)Mockito.verify((Object)this.ccsmTokenService, (VerificationMode)Mockito.never())).getAuthorizedTenantsFromToken((String)ArgumentMatchers.any());
        Assertions.assertThat((List)actualAuthorizedTenants).isEmpty();
    }

    private void assertTenantAuthorization(String authorizedTenantId) {
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeTenant(TEST_USER_ID, IdentityType.USER, authorizedTenantId, "zeebe")).isTrue();
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeTenant(TEST_USER_ID, IdentityType.USER, authorizedTenantId)).isTrue();
    }

    private void assertNoTenantAuthorization(String unauthorizedTenantId) {
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeTenant(TEST_USER_ID, IdentityType.USER, unauthorizedTenantId)).isFalse();
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeTenant(TEST_USER_ID, IdentityType.USER, unauthorizedTenantId, "zeebe")).isFalse();
    }

    private void assertTenantAuthorization(List<String> authorizedTenantIds) {
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeAllTenants(TEST_USER_ID, IdentityType.USER, authorizedTenantIds)).isTrue();
    }

    private void assertNoTenantAuthorization(List<String> unauthorizedTenantIds) {
        Assertions.assertThat((boolean)this.underTest.isAuthorizedToSeeAllTenants(TEST_USER_ID, IdentityType.USER, unauthorizedTenantIds)).isFalse();
    }
}

