/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.snapshot;

import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.BackupState;
import io.camunda.optimize.dto.optimize.rest.BackupInfoDto;
import io.camunda.optimize.service.BackupService;
import io.camunda.optimize.service.util.SnapshotUtil;
import io.camunda.optimize.service.util.configuration.db.DatabaseBackup;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackupServiceIT
extends AbstractCCSMIT {
    private static final Long VALID_BACKUP_ID = 123L;
    private static final String VALID_REPOSITORY_NAME = "my_backup_1";

    @Test
    public void backupApi() throws IOException {
        databaseIntegrationTestExtension.cleanSnapshots(VALID_REPOSITORY_NAME);
        databaseIntegrationTestExtension.createRepoSnapshot(VALID_REPOSITORY_NAME);
        databaseIntegrationTestExtension.createSnapshot(VALID_REPOSITORY_NAME, SnapshotUtil.getSnapshotNameForImportIndices((Long)VALID_BACKUP_ID), databaseIntegrationTestExtension.getIndexNames());
        DatabaseBackup databaseBackup = new DatabaseBackup();
        databaseBackup.setSnapshotRepositoryName(VALID_REPOSITORY_NAME);
        embeddedOptimizeExtension.getConfigurationService().getElasticSearchConfiguration().setBackup(databaseBackup);
        embeddedOptimizeExtension.getConfigurationService().getOpenSearchConfiguration().setBackup(databaseBackup);
        BackupInfoDto backupInfoDto = embeddedOptimizeExtension.getBean(BackupService.class).getSingleBackupInfo(VALID_BACKUP_ID);
        Assertions.assertThat((Comparable)backupInfoDto.getState()).isEqualTo((Object)BackupState.INCOMPLETE);
    }
}

