/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.metrics;

import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.OptimizeRequestExecutor;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.metrics.MetricResponseDto;
import io.camunda.optimize.util.ZeebeBpmnModels;
import io.camunda.zeebe.protocol.record.ValueType;
import io.micrometer.core.instrument.Statistic;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.springframework.http.HttpStatus;

@Disabled(value="Disabled due to issues with actuator config, to be fixed with OPT-7141")
public class ZeebeMetricsIT
extends AbstractCCSMIT {
    @ParameterizedTest
    @MethodSource(value={"metricRequesters"})
    public void metricsAreCollected(Supplier<OptimizeRequestExecutor> requester) {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        MetricResponseDto response = requester.get().execute(MetricResponseDto.class, HttpStatus.OK.value());
        Stream<String> actualTags = response.getAvailableTags().stream().map(MetricResponseDto.TagDto::getTag);
        Assertions.assertThat(actualTags).contains((Object[])new String[]{"RECORD_TYPE", "PARTITION_ID"});
        this.validateResults(response);
    }

    @ParameterizedTest
    @MethodSource(value={"metricRequesters"})
    public void metricsAreCollectedByTags(Supplier<OptimizeRequestExecutor> requester) {
        this.deployAndStartInstanceForProcess(ZeebeBpmnModels.createStartEndProcess("someProcess"));
        this.waitUntilMinimumProcessInstanceEventsExportedCount(1);
        this.importAllZeebeEntitiesFromScratch();
        MetricResponseDto response = requester.get().addSingleQueryParam("tag", "RECORD_TYPE:" + String.valueOf(ValueType.PROCESS_INSTANCE)).execute(MetricResponseDto.class, HttpStatus.OK.value());
        Stream<String> actualTags = response.getAvailableTags().stream().map(MetricResponseDto.TagDto::getTag);
        Assertions.assertThat(actualTags).contains((Object[])new String[]{"PARTITION_ID"});
        this.validateResults(response);
    }

    private void validateResults(MetricResponseDto response) {
        MetricResponseDto.StatisticDto statistic = this.getStatistic(response, Statistic.TOTAL_TIME);
        Double totalTime = statistic.getValue();
        Assertions.assertThat((Object)statistic).isNotNull();
        Assertions.assertThat((Double)totalTime).isGreaterThan(0.0);
        statistic = this.getStatistic(response, Statistic.COUNT);
        Assertions.assertThat((Object)statistic).isNotNull();
        Assertions.assertThat((Double)statistic.getValue()).isGreaterThan(0.0);
        statistic = this.getStatistic(response, Statistic.MAX);
        Assertions.assertThat((Object)statistic).isNotNull();
        Assertions.assertThat((Double)statistic.getValue()).isGreaterThan(0.0).isLessThan((Comparable)totalTime);
    }

    private MetricResponseDto.StatisticDto getStatistic(MetricResponseDto response, Statistic statistic) {
        return response.getMeasurements().stream().filter(m -> m.getStatistic().equals((Object)statistic)).findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("The response from actuator doesn't contain the requested metric"));
    }

    private static Stream<Supplier<OptimizeRequestExecutor>> metricRequesters() {
        return Stream.of(() -> embeddedOptimizeExtension.getRequestExecutor().setActuatorWebTarget().buildIndexingTimeMetricRequest(), () -> embeddedOptimizeExtension.getRequestExecutor().setActuatorWebTarget().buildPageFetchTimeMetricRequest(), () -> embeddedOptimizeExtension.getRequestExecutor().setActuatorWebTarget().buildOverallImportTimeMetricRequest());
    }
}

