/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.client.api.response.Process;
import io.camunda.optimize.AbstractCCSMIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.util.ZeebeBpmnModels;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"variable-import-disabled"})
public class ZeebeVariableImportDisabledIT
extends AbstractCCSMIT {
    private static final String PROCESS_ID = "demoProcess";
    private static final Map<String, Object> BASIC_VARIABLES = Map.of("var1", "someValue", "var2", false, "var3", 123, "var4", 123.3, "var5", "");

    @Test
    public void zeebeVariableImport_processStartedWithVariables() {
        Long processInstanceKey = this.deployProcessAndStartProcessInstanceWithVariables();
        this.waitUntilMinimumProcessInstanceEventsExportedCount(4);
        this.importAllZeebeEntitiesFromScratch();
        ProcessInstanceDto savedProcessInstance = this.getProcessInstanceForId(String.valueOf(processInstanceKey));
        this.assertThatVariablesNotImported(savedProcessInstance);
    }

    private Long deployProcessAndStartProcessInstanceWithVariables() {
        Process deployedProcess = zeebeExtension.deployProcess(ZeebeBpmnModels.createStartEndProcess(PROCESS_ID));
        return zeebeExtension.startProcessInstanceWithVariables(deployedProcess.getBpmnProcessId(), BASIC_VARIABLES);
    }

    private ProcessInstanceDto getProcessInstanceForId(String processInstanceId) {
        return (ProcessInstanceDto)databaseIntegrationTestExtension.getAllProcessInstances().stream().filter(instance -> instance.getProcessInstanceId().equals(processInstanceId)).collect(Collectors.toList()).stream().findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("No process instance with id " + processInstanceId + " found"));
    }

    private void assertThatVariablesNotImported(ProcessInstanceDto processInstanceDto) {
        Assertions.assertThat((List)processInstanceDto.getVariables()).hasSize(0);
    }
}

