/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.identity.UserTaskIdentityService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CloudUserTaskIdentityServiceTest {
    public static final String EXTERNAL_ID = "externalId";
    public static final UserDto TEST_USER_1 = new UserDto("123", "Donna Noble", "donna@email.com", Collections.emptyList());
    public static final UserDto TEST_USER_2 = new UserDto("456", "John Smith", "john@email.com", Collections.emptyList());
    @Mock
    AbstractIdentityService identityService;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    ConfigurationService configurationService;
    private UserTaskIdentityService underTest;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.configurationService.getCaches().getUsers().getMaxSize()).thenReturn((Object)10000);
        Mockito.when((Object)this.configurationService.getCaches().getUsers().getDefaultTtlMillis()).thenReturn((Object)600000);
        this.underTest = new UserTaskIdentityService(this.identityService, this.configurationService);
    }

    @Test
    public void searchAmongIdentitiesWithIdsEmptySearchTermReturnsAllUsers() {
        Mockito.when((Object)this.identityService.getUsersById((Set)ArgumentMatchers.any())).thenReturn(Stream.of(TEST_USER_1, TEST_USER_2).map(IdentityWithMetadataResponseDto.class::cast).toList());
        List<String> idsToSearchAmongst = Stream.of(TEST_USER_1.getId(), TEST_USER_2.getId(), EXTERNAL_ID).toList();
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds("", idsToSearchAmongst, IdentityType.USER, 10);
        ((ListAssert)Assertions.assertThat((List)result.getResult()).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{TEST_USER_1, TEST_USER_2, new UserDto(EXTERNAL_ID)});
    }

    @Test
    public void searchAmongIdentitiesWithIdsEmptySearchTermReturnsAllGroups() {
        List<String> idsToSearchAmongst = Stream.of(EXTERNAL_ID).toList();
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds("", idsToSearchAmongst, IdentityType.GROUP, 10);
        ((ListAssert)Assertions.assertThat((List)result.getResult()).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new GroupDto(EXTERNAL_ID)});
    }

    @Test
    public void searchAmongIdentitiesWithIdsWithMatchInInternalCache() {
        Mockito.when((Object)this.identityService.searchForIdentitiesAsUser((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new IdentitySearchResultResponseDto(List.of(TEST_USER_1)));
        List idsToSearchAmongst = Stream.of(TEST_USER_1.getId(), TEST_USER_2.getId(), EXTERNAL_ID).collect(Collectors.toList());
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds("test", idsToSearchAmongst, IdentityType.USER, 10);
        ((ListAssert)Assertions.assertThat((List)result.getResult()).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{TEST_USER_1});
    }

    @Test
    public void searchAmongIdentitiesWithIdsWithMatchInExternalCache() {
        Mockito.when((Object)this.identityService.getUserById(EXTERNAL_ID)).thenReturn(Optional.empty());
        this.underTest.getIdentityByIdAndType(EXTERNAL_ID, IdentityType.USER);
        Mockito.when((Object)this.identityService.searchForIdentitiesAsUser((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new IdentitySearchResultResponseDto(Collections.emptyList()));
        List idsToSearchAmongst = Stream.of(TEST_USER_1.getId(), TEST_USER_2.getId(), EXTERNAL_ID).collect(Collectors.toList());
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds(EXTERNAL_ID, idsToSearchAmongst, IdentityType.USER, 10);
        ((ListAssert)Assertions.assertThat((List)result.getResult()).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new UserDto(EXTERNAL_ID)});
    }

    @Test
    public void searchAmongIdentitiesWithIdsNoMatchesInInternalOrExternalCache() {
        Mockito.when((Object)this.identityService.searchForIdentitiesAsUser((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new IdentitySearchResultResponseDto(Collections.emptyList()));
        List idsToSearchAmongst = Stream.of(TEST_USER_1.getId(), TEST_USER_2.getId(), EXTERNAL_ID).collect(Collectors.toList());
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds("test", idsToSearchAmongst, IdentityType.USER, 10);
        Assertions.assertThat((List)result.getResult()).isEmpty();
    }

    @Test
    public void searchAmongIdentitiesWithIdsResultLimitApplied() {
        Mockito.when((Object)this.identityService.searchForIdentitiesAsUser((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new IdentitySearchResultResponseDto(List.of(TEST_USER_1, TEST_USER_2)));
        List idsToSearchAmongst = Stream.of(TEST_USER_1.getId(), TEST_USER_2.getId(), EXTERNAL_ID).collect(Collectors.toList());
        IdentitySearchResultResponseDto result = this.underTest.searchAmongIdentitiesWithIds("test", idsToSearchAmongst, IdentityType.USER, 1);
        ((ListAssert)Assertions.assertThat((List)result.getResult()).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{TEST_USER_1});
    }

    @Test
    public void getIdentitiesWithMatchInInternalCache() {
        Mockito.when((Object)this.identityService.getUsersById(new HashSet<String>(List.of(TEST_USER_1.getId())))).thenReturn(Stream.of(TEST_USER_1).map(IdentityWithMetadataResponseDto.class::cast).collect(Collectors.toList()));
        List result = this.underTest.getIdentities(Stream.of(new IdentityDto(TEST_USER_1.getId(), IdentityType.USER)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{TEST_USER_1});
    }

    @Test
    public void getIdentitiesNoMatchReturnsDefaultAndAddsToExternalCache() {
        Mockito.when((Object)this.identityService.getUsersById(Set.of(EXTERNAL_ID))).thenReturn(Collections.emptyList());
        List result = this.underTest.getIdentities(Stream.of(new IdentityDto(EXTERNAL_ID, IdentityType.USER)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new UserDto(EXTERNAL_ID)});
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.times((int)1))).getUsersById(Set.of(EXTERNAL_ID));
        Mockito.reset((Object[])new AbstractIdentityService[]{this.identityService});
        result = this.underTest.getIdentities(Stream.of(new IdentityDto(EXTERNAL_ID, IdentityType.USER)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new UserDto(EXTERNAL_ID)});
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.never())).getUsersById(Set.of(EXTERNAL_ID));
    }

    @Test
    public void getIdentitiesOneInternalOneExternal() {
        Mockito.when((Object)this.identityService.getUsersById(Set.of(TEST_USER_1.getId(), EXTERNAL_ID))).thenReturn(Stream.of(TEST_USER_1).map(IdentityWithMetadataResponseDto.class::cast).collect(Collectors.toList()));
        List result = this.underTest.getIdentities(Stream.of(TEST_USER_1, new IdentityDto(EXTERNAL_ID, IdentityType.USER)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{TEST_USER_1, new UserDto(EXTERNAL_ID)});
    }

    @Test
    public void getIdentitiesGroupsReturnedAsDefaultAndAddedToExternalCache() {
        Mockito.when((Object)this.identityService.getGroupsById(Set.of(EXTERNAL_ID))).thenReturn(Collections.emptyList());
        List result = this.underTest.getIdentities(Stream.of(new IdentityDto(EXTERNAL_ID, IdentityType.GROUP)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new GroupDto(EXTERNAL_ID)});
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.times((int)1))).getGroupsById(Set.of(EXTERNAL_ID));
        Mockito.reset((Object[])new AbstractIdentityService[]{this.identityService});
        result = this.underTest.getIdentities(Stream.of(new IdentityDto(EXTERNAL_ID, IdentityType.GROUP)).toList());
        ((ListAssert)Assertions.assertThat((List)result).usingRecursiveFieldByFieldElementComparator()).containsExactly((Object[])new IdentityWithMetadataResponseDto[]{new GroupDto(EXTERNAL_ID)});
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.never())).getGroupsById(Set.of(EXTERNAL_ID));
    }

    @Test
    public void getIdentityByIdAndTypeWithMatchInInternalCache() {
        Mockito.when((Object)this.identityService.getUserById(TEST_USER_1.getId())).thenReturn(Optional.of(TEST_USER_1));
        Optional result = this.underTest.getIdentityByIdAndType(TEST_USER_1.getId(), IdentityType.USER);
        Assertions.assertThat((Optional)result).contains((Object)TEST_USER_1);
    }

    @Test
    public void getIdentityByIdAndTypeNoMatchReturnsDefaultAndAddsToExternalCache() {
        Mockito.when((Object)this.identityService.getUserById(EXTERNAL_ID)).thenReturn(Optional.empty());
        Optional result = this.underTest.getIdentityByIdAndType(EXTERNAL_ID, IdentityType.USER);
        Assertions.assertThat((Optional)result).contains((Object)new UserDto(EXTERNAL_ID));
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.times((int)1))).getUserById(EXTERNAL_ID);
        Mockito.reset((Object[])new AbstractIdentityService[]{this.identityService});
        result = this.underTest.getIdentityByIdAndType(EXTERNAL_ID, IdentityType.USER);
        Assertions.assertThat((Optional)result).contains((Object)new UserDto(EXTERNAL_ID));
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.never())).getUserById(EXTERNAL_ID);
    }

    @Test
    public void getIdentityByIdAndTypeGroupReturnsDefaultAndAddsToExternalCache() {
        Mockito.when((Object)this.identityService.getGroupById(EXTERNAL_ID)).thenReturn(Optional.empty());
        Optional result = this.underTest.getIdentityByIdAndType(EXTERNAL_ID, IdentityType.GROUP);
        Assertions.assertThat((Optional)result).contains((Object)new GroupDto(EXTERNAL_ID));
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.times((int)1))).getGroupById(EXTERNAL_ID);
        Mockito.reset((Object[])new AbstractIdentityService[]{this.identityService});
        result = this.underTest.getIdentityByIdAndType(EXTERNAL_ID, IdentityType.GROUP);
        Assertions.assertThat((Optional)result).contains((Object)new GroupDto(EXTERNAL_ID));
        ((AbstractIdentityService)Mockito.verify((Object)this.identityService, (VerificationMode)Mockito.never())).getGroupById(EXTERNAL_ID);
    }
}

