/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.export;

import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataCountDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.service.db.report.result.RawDataCommandResult;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.export.RawDataHelper;
import java.lang.invoke.CallSite;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CSVUtilsTest {
    @Test
    public void testRawProcessResultMappingNewVariablesAndDtoFieldsAreExcludedWhenSetInReportConfig() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        List<String> unexpectedVariableColumns = toMap.get(0).getVariables().keySet().stream().map(varName -> "variable:" + varName).toList();
        List expectedDtoFieldColumns = CSVUtils.extractAllProcessInstanceDtoFieldKeys();
        List<String[]> result = CSVUtilsTest.mapRawProcessReportInstances(toMap, false);
        Assertions.assertThat(result).hasSize(4);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])result.get(0)).hasSize(8)).doesNotContainAnyElementsOf(unexpectedVariableColumns)).containsAll((Iterable)expectedDtoFieldColumns);
    }

    @Test
    public void testRawProcessResultMappingNewVariablesAndDtoFieldsAreIncludedWhenSet() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        List<String> expectedVariableColumns = toMap.stream().filter(instance -> instance.getVariables() != null).flatMap(instance -> instance.getVariables().keySet().stream()).map(varName -> "variable:" + varName).toList();
        List expectedDtoFieldColumns = CSVUtils.extractAllProcessInstanceDtoFieldKeys();
        List<String[]> result = CSVUtilsTest.mapRawProcessReportInstances(toMap, true);
        Assertions.assertThat(result).hasSize(4);
        ((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])result.get(0)).hasSize(8 + expectedVariableColumns.size())).containsAll(expectedVariableColumns)).containsAll((Iterable)expectedDtoFieldColumns);
    }

    @Test
    public void testRawProcessResultMappingTestQuoteEscapingInValue() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("\"1\"", "test");
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtoWithVariables(variables);
        String expectedString = "\"processDefinitionKey\",\"processDefinitionId\",\"processInstanceId\",\"startDate\",\"endDate\",\"duration\",\"engineName\",\"tenantId\",\"variable:\"\"1\"\"\"\r\n\"test_key\",\"test_id\",,\"2018-02-23T14:31:08.048+01:00\",\"2018-02-23T14:31:08.048+01:00\",\"0\",\"engine\",\"tenant\",\"test\"\r\n";
        String resultString = new String(CSVUtils.mapCsvLinesToCsvBytes(CSVUtilsTest.mapRawProcessReportInstances(toMap, true), (char)','));
        Assertions.assertThat((String)resultString).isEqualTo("\"processDefinitionKey\",\"processDefinitionId\",\"processInstanceId\",\"startDate\",\"endDate\",\"duration\",\"engineName\",\"tenantId\",\"variable:\"\"1\"\"\"\r\n\"test_key\",\"test_id\",,\"2018-02-23T14:31:08.048+01:00\",\"2018-02-23T14:31:08.048+01:00\",\"0\",\"engine\",\"tenant\",\"test\"\r\n");
    }

    @ParameterizedTest
    @MethodSource(value={"getExpectedStringAndCsvDelimiter"})
    public void testRawProcessResultMappingCsvWorksWithSeveralDelimiters(String expectedString, char delimiter) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("\"1\"", "test");
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtoWithVariables(variables);
        String resultString = new String(CSVUtils.mapCsvLinesToCsvBytes(CSVUtilsTest.mapRawProcessReportInstances(toMap, true), (char)delimiter));
        Assertions.assertThat((String)resultString).isEqualTo(expectedString);
    }

    @Test
    public void testRawProcessResultMappingWithIncludingAndExcludingFields() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{RawDataProcessInstanceDto.class.getDeclaredFields()[0].getName()});
        SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(CSVUtils.extractAllProcessInstanceDtoFieldKeys().size() - excludedColumns.size() + RawDataCountDto.Fields.values().length)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawProcessResultMappingWithIncludingAndExcludingSameFieldExcludeWins() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        List includedColumns = CSVUtils.extractAllProcessInstanceDtoFieldKeys();
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{RawDataProcessInstanceDto.class.getDeclaredFields()[1].getName()});
        SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(includedColumns.size() - excludedColumns.size() + RawDataCountDto.Fields.values().length)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawProcessResultMappingWithExcludingVariables() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        ArrayList firstRowVariableColumnNames = Lists.newArrayList(toMap.get(0).getVariables().keySet());
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{"variable:" + (String)firstRowVariableColumnNames.get(0)});
        SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault(), false);
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(8)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawProcessResultMappingWithIncludingVariables() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        ArrayList firstRowVariableColumnNames = Lists.newArrayList(toMap.get(0).getVariables().keySet());
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"variable:" + (String)firstRowVariableColumnNames.get(0)});
        includedColumns.addAll(CSVUtils.extractAllProcessInstanceDtoFieldKeys());
        SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault(), false);
        Assertions.assertThat((List)result).hasSize(4);
        Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(includedColumns.size());
    }

    @Test
    public void testRawProcessResultMappingWithIncludingVariableAndExcludingSameVariableExcludeWins() {
        List<RawDataProcessInstanceDto> toMap = RawDataHelper.getRawDataProcessInstanceDtos();
        ArrayList firstRowVariableColumnNames = Lists.newArrayList(toMap.get(0).getVariables().keySet());
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"variable:" + (String)firstRowVariableColumnNames.get(1)});
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{"variable:" + (String)firstRowVariableColumnNames.get(1)});
        SingleProcessReportDefinitionRequestDto reportDefinition = new SingleProcessReportDefinitionRequestDto();
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((ProcessReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault(), false);
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(8)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingNewVariablesAreExcludedAndDtoFieldsAreIncludedByDefault() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        List<String> unexpectedInputVariableColumns = toMap.get(0).getInputVariables().keySet().stream().map(varName -> "input:" + varName).toList();
        List<String> unexpectedOutputVariableColumns = toMap.get(0).getOutputVariables().keySet().stream().map(varName -> "output:" + varName).toList();
        List expectedDtoFieldColumns = CSVUtils.extractAllDecisionInstanceDtoFieldKeys();
        List<String[]> result = CSVUtilsTest.mapRawDecisionReportInstances(toMap);
        Assertions.assertThat(result).hasSize(4);
        ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])result.get(0)).hasSize(7)).containsAll((Iterable)expectedDtoFieldColumns)).doesNotContainAnyElementsOf(unexpectedInputVariableColumns)).doesNotContainAnyElementsOf(unexpectedOutputVariableColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithExcludingFields() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{RawDataDecisionInstanceDto.class.getDeclaredFields()[0].getName(), RawDataDecisionInstanceDto.class.getDeclaredFields()[1].getName()});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(CSVUtils.extractAllDecisionInstanceDtoFieldKeys().size() - excludedColumns.size())).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithIncludingFieldAndExcludingSameFieldExcludeWins() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{RawDataDecisionInstanceDto.class.getDeclaredFields()[1].getName()});
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{RawDataDecisionInstanceDto.class.getDeclaredFields()[1].getName()});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(7 - excludedColumns.size())).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithExcludingInputVariables() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowInputVariableColumnNames = Lists.newArrayList(toMap.get(0).getInputVariables().keySet());
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{"input:" + (String)firstRowInputVariableColumnNames.get(1)});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(7)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithIncludingInputVariables() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowInputVariableColumnNames = Lists.newArrayList(toMap.get(0).getInputVariables().keySet());
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"input:" + (String)firstRowInputVariableColumnNames.get(1)});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(CSVUtils.extractAllDecisionInstanceDtoFieldKeys().size() + includedColumns.size())).containsAll((Iterable)includedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithIncludingInputVariableAndExcludingSameVariableExcludeWins() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowInputVariableColumnNames = Lists.newArrayList(toMap.get(0).getInputVariables().keySet());
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"input:" + (String)firstRowInputVariableColumnNames.get(1)});
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{"input:" + (String)firstRowInputVariableColumnNames.get(1)});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(7)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithExcludingOutputVariable() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowOutputVariableColumnNames = Lists.newArrayList(toMap.get(0).getOutputVariables().keySet());
        ArrayList excludedColumns = Lists.newArrayList((Object[])new String[]{"output:" + (String)firstRowOutputVariableColumnNames.get(0)});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(7)).doesNotContainAnyElementsOf((Iterable)excludedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithIncludingOutputVariable() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowOutputVariableColumnNames = Lists.newArrayList(toMap.get(0).getOutputVariables().keySet());
        ArrayList includedColumns = Lists.newArrayList((Object[])new String[]{"output:" + (String)firstRowOutputVariableColumnNames.get(0)});
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().setIncludeNewVariables(false);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(CSVUtils.extractAllDecisionInstanceDtoFieldKeys().size() + includedColumns.size())).containsAnyElementsOf((Iterable)includedColumns);
    }

    @Test
    public void testRawDecisionResultMappingWithIncludingOutputVariableAndExcludingSameVariableExcludeWins() {
        List<RawDataDecisionInstanceDto> toMap = RawDataHelper.getRawDataDecisionInstanceDtos();
        ArrayList firstRowOutputVariableColumnNames = Lists.newArrayList(toMap.get(0).getOutputVariables().keySet());
        List<CallSite> includedColumns = Collections.singletonList("output:" + (String)firstRowOutputVariableColumnNames.get(1));
        List<CallSite> excludedColumns = Collections.singletonList("output:" + (String)firstRowOutputVariableColumnNames.get(1));
        SingleDecisionReportDefinitionRequestDto reportDefinition = new SingleDecisionReportDefinitionRequestDto();
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getIncludedColumns().addAll(includedColumns);
        ((DecisionReportDataDto)reportDefinition.getData()).getConfiguration().getTableColumns().getExcludedColumns().addAll(excludedColumns);
        RawDataCommandResult rawDataReportResult = new RawDataCommandResult(toMap, (SingleReportDataDto)reportDefinition.getData());
        List result = rawDataReportResult.getResultAsCsv(Integer.valueOf(10), null, ZoneId.systemDefault());
        Assertions.assertThat((List)result).hasSize(4);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])((String[])result.get(0))).hasSize(7)).doesNotContainAnyElementsOf(excludedColumns);
    }

    private static List<String[]> mapRawProcessReportInstances(List<RawDataProcessInstanceDto> rawData, boolean includeNewVariables) {
        return CSVUtils.mapRawProcessReportInstances(rawData, null, null, (TableColumnDto)new TableColumnDto(), (boolean)includeNewVariables);
    }

    private static List<String[]> mapRawDecisionReportInstances(List<RawDataDecisionInstanceDto> rawData) {
        return CSVUtils.mapRawDecisionReportInstances(rawData, null, null, (TableColumnDto)new TableColumnDto());
    }

    private static Stream<Arguments> getExpectedStringAndCsvDelimiter() {
        return Stream.of(Arguments.of((Object[])new Object[]{"\"processDefinitionKey\",\"processDefinitionId\",\"processInstanceId\",\"startDate\",\"endDate\",\"duration\",\"engineName\",\"tenantId\",\"variable:\"\"1\"\"\"\r\n\"test_key\",\"test_id\",,\"2018-02-23T14:31:08.048+01:00\",\"2018-02-23T14:31:08.048+01:00\",\"0\",\"engine\",\"tenant\",\"test\"\r\n", Character.valueOf(',')}), Arguments.of((Object[])new Object[]{"\"processDefinitionKey\";\"processDefinitionId\";\"processInstanceId\";\"startDate\";\"endDate\";\"duration\";\"engineName\";\"tenantId\";\"variable:\"\"1\"\"\"\r\n\"test_key\";\"test_id\";;\"2018-02-23T14:31:08.048+01:00\";\"2018-02-23T14:31:08.048+01:00\";\"0\";\"engine\";\"tenant\";\"test\"\r\n", Character.valueOf(';')}), Arguments.of((Object[])new Object[]{"\"processDefinitionKey\"\t\"processDefinitionId\"\t\"processInstanceId\"\t\"startDate\"\t\"endDate\"\t\"duration\"\t\"engineName\"\t\"tenantId\"\t\"variable:\"\"1\"\"\"\r\n\"test_key\"\t\"test_id\"\t\t\"2018-02-23T14:31:08.048+01:00\"\t\"2018-02-23T14:31:08.048+01:00\"\t\"0\"\t\"engine\"\t\"tenant\"\t\"test\"\r\n", Character.valueOf('\t')}), Arguments.of((Object[])new Object[]{"\"processDefinitionKey\"|\"processDefinitionId\"|\"processInstanceId\"|\"startDate\"|\"endDate\"|\"duration\"|\"engineName\"|\"tenantId\"|\"variable:\"\"1\"\"\"\r\n\"test_key\"|\"test_id\"||\"2018-02-23T14:31:08.048+01:00\"|\"2018-02-23T14:31:08.048+01:00\"|\"0\"|\"engine\"|\"tenant\"|\"test\"\r\n", Character.valueOf('|')}), Arguments.of((Object[])new Object[]{"\"processDefinitionKey\" \"processDefinitionId\" \"processInstanceId\" \"startDate\" \"endDate\" \"duration\" \"engineName\" \"tenantId\" \"variable:\"\"1\"\"\"\r\n\"test_key\" \"test_id\"  \"2018-02-23T14:31:08.048+01:00\" \"2018-02-23T14:31:08.048+01:00\" \"0\" \"engine\" \"tenant\" \"test\"\r\n", Character.valueOf(' ')}));
    }
}

