/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.service.cleanup.CleanupScheduler;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.ConfigurationServiceBuilder;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CleanupSchedulerTest {
    private ConfigurationService configurationService;

    @BeforeEach
    public void init() {
        this.configurationService = ConfigurationServiceBuilder.createDefaultConfiguration();
    }

    @Test
    public void testAllEnabledCleanupServicesAreCalled() {
        CleanupScheduler underTest = this.createOptimizeCleanupServiceToTest();
        CleanupService mockedCleanupService1 = (CleanupService)Mockito.mock(CleanupService.class);
        CleanupService mockedCleanupService2 = (CleanupService)Mockito.mock(CleanupService.class);
        CleanupService mockedCleanupService3 = (CleanupService)Mockito.mock(CleanupService.class);
        Mockito.when((Object)mockedCleanupService1.isEnabled()).thenReturn((Object)true);
        ((CleanupService)Mockito.doNothing().when((Object)mockedCleanupService1)).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        Mockito.when((Object)mockedCleanupService2.isEnabled()).thenReturn((Object)true);
        ((CleanupService)Mockito.doNothing().when((Object)mockedCleanupService2)).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        Mockito.when((Object)mockedCleanupService3.isEnabled()).thenReturn((Object)false);
        underTest.getCleanupServices().add(mockedCleanupService1);
        underTest.getCleanupServices().add(mockedCleanupService2);
        underTest.getCleanupServices().add(mockedCleanupService3);
        underTest.runCleanup();
        ((CleanupService)Mockito.verify((Object)mockedCleanupService1, (VerificationMode)Mockito.times((int)1))).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        ((CleanupService)Mockito.verify((Object)mockedCleanupService2, (VerificationMode)Mockito.times((int)1))).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        ((CleanupService)Mockito.verify((Object)mockedCleanupService3, (VerificationMode)Mockito.never())).doCleanup((OffsetDateTime)ArgumentMatchers.any());
    }

    @Test
    public void testFailingCleanupServiceDoesntAffectOthersExecution() {
        CleanupScheduler underTest = this.createOptimizeCleanupServiceToTest();
        CleanupService mockedCleanupService1 = (CleanupService)Mockito.mock(CleanupService.class);
        CleanupService mockedCleanupService2 = (CleanupService)Mockito.mock(CleanupService.class);
        Mockito.when((Object)mockedCleanupService1.isEnabled()).thenReturn((Object)true);
        ((CleanupService)Mockito.doThrow(RuntimeException.class).when((Object)mockedCleanupService1)).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        Mockito.when((Object)mockedCleanupService2.isEnabled()).thenReturn((Object)true);
        ((CleanupService)Mockito.doNothing().when((Object)mockedCleanupService2)).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        underTest.getCleanupServices().add(mockedCleanupService1);
        underTest.getCleanupServices().add(mockedCleanupService2);
        underTest.runCleanup();
        ((CleanupService)Mockito.verify((Object)mockedCleanupService1, (VerificationMode)Mockito.times((int)1))).doCleanup((OffsetDateTime)ArgumentMatchers.any());
        ((CleanupService)Mockito.verify((Object)mockedCleanupService2, (VerificationMode)Mockito.times((int)1))).doCleanup((OffsetDateTime)ArgumentMatchers.any());
    }

    @Test
    public void testFailInitOnInvalidConfig() {
        this.getCleanupConfiguration().setTtl(null);
        CleanupScheduler underTest = this.createOptimizeCleanupServiceToTest();
        AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConfigurationException.class).isThrownBy(() -> ((CleanupScheduler)underTest).init());
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }

    private CleanupScheduler createOptimizeCleanupServiceToTest() {
        return new CleanupScheduler(this.configurationService, new ArrayList());
    }
}

