/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.backup;

import io.camunda.optimize.dto.optimize.rest.SnapshotInfoDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.BackupService;
import io.camunda.optimize.service.db.reader.BackupReader;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeSnapshotRepositoryNotFoundException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BackupServiceTest {
    private static MockedStatic<StringUtils> stringUtils;
    @Mock
    private BackupReader backupReader;
    @InjectMocks
    private BackupService backupService;

    @BeforeAll
    public static void beforeAll() {
        stringUtils = Mockito.mockStatic(StringUtils.class);
    }

    @AfterAll
    public static void afterAll() {
        stringUtils.close();
    }

    @Test
    public void triggerBackupWithoutSnapshotRepositoryConfig() {
        OptimizeConfigurationException optimizeConfigurationException = new OptimizeConfigurationException("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{optimizeConfigurationException}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeConfigurationException thrown = (OptimizeConfigurationException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConfigurationException.class).isThrownBy(() -> this.backupService.triggerBackup(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
    }

    @Test
    public void triggerBackupWithIncorrectSnapshotRepositoryConfig() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{new OptimizeSnapshotRepositoryNotFoundException("No repository with name [does_not_exist] could be found.")}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeRuntimeException thrown = (OptimizeRuntimeException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeRuntimeException.class).isThrownBy(() -> this.backupService.triggerBackup(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("No repository with name [does_not_exist] could be found.");
    }

    @Test
    public void triggerBackupWithDuplicateBackupId() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        SnapshotInfoDto snapshotInfoDtoMock = (SnapshotInfoDto)Mockito.mock(SnapshotInfoDto.class);
        Mockito.when((Object)snapshotInfoDtoMock.getSnapshotName()).thenReturn((Object)"existingSnapshotName/Xtll5DxHQ56j6rMz8nFDmQ");
        ((BackupReader)Mockito.doReturn(List.of(snapshotInfoDtoMock)).when((Object)this.backupReader)).getOptimizeSnapshotsForBackupId((Long)ArgumentMatchers.any());
        OptimizeConflictException thrown = (OptimizeConflictException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConflictException.class).isThrownBy(() -> this.backupService.triggerBackup(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("A backup with ID [123] already exists. Found snapshots: [existingSnapshotName/Xtll5DxHQ56j6rMz8nFDmQ]");
    }

    @Test
    public void getSpecificBackupStateWithoutSnapshotRepositoryConfig() {
        OptimizeConfigurationException optimizeConfigurationException = new OptimizeConfigurationException("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{optimizeConfigurationException}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeConfigurationException thrown = (OptimizeConfigurationException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConfigurationException.class).isThrownBy(() -> this.backupService.getSingleBackupInfo(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
    }

    @Test
    public void getSpecificBackupStateWithIncorrectSnapshotRepositoryConfig() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{new OptimizeSnapshotRepositoryNotFoundException("No repository with name [does_not_exist] could be found.")}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeRuntimeException thrown = (OptimizeRuntimeException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeRuntimeException.class).isThrownBy(() -> this.backupService.getSingleBackupInfo(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("No repository with name [does_not_exist] could be found.");
    }

    @Test
    public void getSpecificBackupStateNonExistentBackupId() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doNothing().when((Object)this.backupReader)).validateRepositoryExists();
        Mockito.when((Object)this.backupReader.getOptimizeSnapshotsForBackupId(Long.valueOf(ArgumentMatchers.anyLong()))).thenReturn(Collections.emptyList());
        NotFoundException thrown = (NotFoundException)AssertionsForClassTypes.assertThatExceptionOfType(NotFoundException.class).isThrownBy(() -> this.backupService.getSingleBackupInfo(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("No Optimize backup with ID [123] could be found.");
    }

    @Test
    public void getAllBackupStateWithoutSnapshotRepositoryConfig() {
        OptimizeConfigurationException optimizeConfigurationException = new OptimizeConfigurationException("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{optimizeConfigurationException}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeConfigurationException thrown = (OptimizeConfigurationException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConfigurationException.class).isThrownBy(() -> this.backupService.getAllBackupInfo()).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
    }

    @Test
    public void getAllBackupStateWithIncorrectSnapshotRepositoryConfig() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{new OptimizeSnapshotRepositoryNotFoundException("No repository with name [does_not_exist] could be found.")}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeRuntimeException thrown = (OptimizeRuntimeException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeRuntimeException.class).isThrownBy(() -> this.backupService.getAllBackupInfo()).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("No repository with name [does_not_exist] could be found.");
    }

    @Test
    public void getAllBackupStateNonExistentBackupId() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doNothing().when((Object)this.backupReader)).validateRepositoryExists();
        Mockito.when((Object)this.backupReader.getAllOptimizeSnapshotsByBackupId()).thenReturn(Collections.emptyMap());
        Assertions.assertThat((List)this.backupService.getAllBackupInfo()).isEmpty();
    }

    @Test
    public void deleteBackupWithoutSnapshotRepositoryConfig() {
        OptimizeConfigurationException optimizeConfigurationException = new OptimizeConfigurationException("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{optimizeConfigurationException}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeConfigurationException thrown = (OptimizeConfigurationException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeConfigurationException.class).isThrownBy(() -> this.backupService.deleteBackup(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("Cannot execute backup request because no snapshot repository name found in Optimize configuration.");
    }

    @Test
    public void deleteBackupWithIncorrectSnapshotRepositoryConfig() {
        stringUtils.when(() -> StringUtils.isEmpty((CharSequence)((CharSequence)ArgumentMatchers.any()))).thenReturn((Object)false);
        ((BackupReader)Mockito.doThrow((Throwable[])new Throwable[]{new OptimizeSnapshotRepositoryNotFoundException("No repository with name [does_not_exist] could be found.")}).when((Object)this.backupReader)).validateRepositoryExists();
        OptimizeRuntimeException thrown = (OptimizeRuntimeException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeRuntimeException.class).isThrownBy(() -> this.backupService.deleteBackup(Long.valueOf(123L))).actual();
        Assertions.assertThat((String)thrown.getMessage()).isEqualTo("No repository with name [does_not_exist] could be found.");
    }
}

