/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.backup;

import io.camunda.optimize.dto.optimize.rest.BackupRequestDto;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class BackupRequestValidationTest {
    @ParameterizedTest
    @MethodSource(value={"invalidBackupIds"})
    public void triggerBackupWithInvalidBackupId(Long invalidBackupId, String expectedErrorMsg) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        BackupRequestDto backupRequestDto = new BackupRequestDto(invalidBackupId);
        Set violations = validator.validate((Object)backupRequestDto, new Class[0]);
        ((ObjectAssert)Assertions.assertThat((Collection)violations).singleElement()).extracting(ConstraintViolation::getMessage).isEqualTo((Object)expectedErrorMsg);
    }

    private static Stream<Arguments> invalidBackupIds() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "must not be null"}), Arguments.of((Object[])new Object[]{-1L, "must be greater than or equal to 0"}));
    }
}

