/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.service.alert.CCSMAlertRecipientValidator;
import io.camunda.optimize.service.exceptions.OptimizeAlertEmailValidationException;
import io.camunda.optimize.service.identity.CCSMIdentityService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CCSMAlertRecipientValidatorTest {
    private static final String TEST_EMAIL_1 = "test1@test.com";
    private static final String TEST_EMAIL_2 = "test2@test.com";
    private static final UserDto TEST_USER_1 = new UserDto("id1", "name1", "name1", "test1@test.com");
    private static final UserDto TEST_USER_2 = new UserDto("id2", "name2", "name2", "test2@test.com");
    @Mock
    private CCSMIdentityService identityService;
    @InjectMocks
    private CCSMAlertRecipientValidator ccsmAlertRecipientValidator;

    @Test
    public void alertValidationSucceedsWhenAllEmailsKnown() {
        Set<String> emailsToValidate = Set.of(TEST_EMAIL_1, TEST_EMAIL_2);
        Mockito.when((Object)this.identityService.getUsersByEmail(emailsToValidate)).thenReturn(List.of(TEST_USER_1, TEST_USER_2));
        Assertions.assertThatCode(() -> this.ccsmAlertRecipientValidator.validateAlertRecipientEmailAddresses(emailsToValidate.stream().toList())).doesNotThrowAnyException();
    }

    @Test
    public void alertValidationNoErrorsWhenEmpty() {
        Mockito.when((Object)this.identityService.getUsersByEmail(Collections.emptySet())).thenReturn(Collections.emptyList());
        Assertions.assertThatCode(() -> this.ccsmAlertRecipientValidator.validateAlertRecipientEmailAddresses(Collections.emptyList())).doesNotThrowAnyException();
    }

    @Test
    public void alertValidationFailsForUnknownEmails() {
        Set<String> emailsToValidate = Set.of(TEST_EMAIL_1, TEST_EMAIL_2);
        Mockito.when((Object)this.identityService.getUsersByEmail(emailsToValidate)).thenReturn(List.of(TEST_USER_1));
        OptimizeAlertEmailValidationException thrown = (OptimizeAlertEmailValidationException)AssertionsForClassTypes.assertThatExceptionOfType(OptimizeAlertEmailValidationException.class).isThrownBy(() -> this.ccsmAlertRecipientValidator.validateAlertRecipientEmailAddresses(emailsToValidate.stream().toList())).actual();
        Assertions.assertThat((Collection)thrown.getAlertEmails()).containsExactly((Object[])new String[]{TEST_EMAIL_2});
    }
}

