/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.oauth;

import io.camunda.optimize.rest.security.oauth.RoleValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

class RoleValidatorTest {
    private final List<String> allowedRoles = Arrays.asList("admin", "analyst", "owner");
    private final RoleValidator validator = new RoleValidator(this.allowedRoles);

    RoleValidatorTest() {
    }

    @Test
    void shouldFailWhenTokenHasNoOrganizationClaim() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap claims = new HashMap();
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }

    @Test
    void shouldSucceedWhenUserHasAllowedRole() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap claims = new HashMap();
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("id", "org1");
        org.put("roles", Arrays.asList("admin", "developer"));
        claims.put("https://camunda.com/orgs", List.of(org));
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isFalse();
    }

    @Test
    void shouldSucceedWhenUserHasAllowedRoleInAnyOrg() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap<String, List<Map>> claims = new HashMap<String, List<Map>>();
        HashMap<String, Object> org1 = new HashMap<String, Object>();
        org1.put("id", "org1");
        org1.put("roles", List.of("developer"));
        HashMap<String, Object> org2 = new HashMap<String, Object>();
        org2.put("id", "org2");
        org2.put("roles", List.of("analyst"));
        claims.put("https://camunda.com/orgs", Arrays.asList(org1, org2));
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isFalse();
    }

    @Test
    void shouldFailWhenUserHasNoAllowedRole() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap claims = new HashMap();
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("id", "org1");
        org.put("roles", Arrays.asList("developer", "viewer"));
        claims.put("https://camunda.com/orgs", List.of(org));
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
        Assertions.assertThat((String)((OAuth2Error)result.getErrors().iterator().next()).getErrorCode()).isEqualTo("invalid_token");
    }

    @Test
    void shouldFailWhenOrganizationHasNoRoles() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap claims = new HashMap();
        HashMap<String, Object> org = new HashMap<String, Object>();
        org.put("id", "org1");
        org.put("roles", Collections.emptyList());
        claims.put("https://camunda.com/orgs", List.of(org));
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }

    @Test
    void shouldFailWhenOrganizationClaimIsEmpty() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap claims = new HashMap();
        claims.put("https://camunda.com/orgs", Collections.emptyList());
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }

    @Test
    void shouldFailWhenOrganizationClaimHasInvalidStructure() {
        Jwt token = (Jwt)Mockito.mock(Jwt.class);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("https://camunda.com/orgs", "invalid-structure");
        Mockito.when((Object)token.getClaims()).thenReturn(claims);
        OAuth2TokenValidatorResult result = this.validator.validate(token);
        Assertions.assertThat((boolean)result.hasErrors()).isTrue();
    }
}

