/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import io.camunda.optimize.Main;
import io.camunda.optimize.OptimizeTomcatConfig;
import io.camunda.optimize.test.it.extension.DatabaseIntegrationTestExtension;
import io.camunda.optimize.test.it.extension.EmbeddedOptimizeExtension;
import io.camunda.optimize.test.optimize.VariablesClient;
import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, properties={"integrationTests=true"})
@Configuration
public abstract class AbstractIT {
    public static final String OPENSEARCH_PASSING = "openSearchPassing";
    public static final String OPENSEARCH_SINGLE_TEST_FAIL_OK = "openSearchSingleTestFailOK";
    public static final String OPENSEARCH_SHOULD_BE_PASSING = "openSearchShouldBePassing";
    @Autowired
    private Environment environment;
    @RegisterExtension
    @Order(value=1)
    public static DatabaseIntegrationTestExtension databaseIntegrationTestExtension = new DatabaseIntegrationTestExtension();
    @RegisterExtension
    @Order(value=3)
    public static EmbeddedOptimizeExtension embeddedOptimizeExtension = new EmbeddedOptimizeExtension();
    protected VariablesClient variablesClient = new VariablesClient();

    protected abstract void startAndUseNewOptimizeInstance();

    protected void startAndUseNewOptimizeInstance(Map<String, String> argMap, String activeProfile) {
        String[] arguments = this.prepareArgs(argMap);
        embeddedOptimizeExtension.afterTest();
        if (embeddedOptimizeExtension.isCloseContextAfterTest()) {
            ((ConfigurableApplicationContext)embeddedOptimizeExtension.getApplicationContext()).close();
        }
        ConfigurableApplicationContext context = new SpringApplicationBuilder(new Class[]{Main.class}).profiles(new String[]{activeProfile}).build().run(arguments);
        embeddedOptimizeExtension.setApplicationContext((ApplicationContext)context);
        embeddedOptimizeExtension.setCloseContextAfterTest(true);
        embeddedOptimizeExtension.setResetImportOnStart(false);
        embeddedOptimizeExtension.setupOptimize();
    }

    private String[] prepareArgs(Map<String, String> argMap) {
        String httpsPort = this.getPortArg("httpsPort");
        String httpPort = this.getPortArg("httpPort");
        String actuatorPort = this.getArg("management.server.port", String.valueOf(OptimizeResourceConstants.ACTUATOR_PORT + 100));
        String contextPath = embeddedOptimizeExtension.getConfigurationService().getContextPath().map(contextPathFromConfig -> this.getArg("contextPath", (String)contextPathFromConfig)).orElse("");
        List argList = argMap.entrySet().stream().map(e -> this.getArg((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        Collections.addAll(argList, httpsPort, httpPort, actuatorPort, contextPath);
        return (String[])argList.toArray(String[]::new);
    }

    private String getPortArg(String portKey) {
        return this.getArg(portKey, String.valueOf(embeddedOptimizeExtension.getBean(OptimizeTomcatConfig.class).getPort(portKey) + 100));
    }

    private String getArg(String key, String value) {
        return String.format("--%s=%s", key, value);
    }
}

