/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize;

import io.camunda.client.api.response.Process;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.optimize.AbstractIT;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceDataDto;
import io.camunda.optimize.dto.zeebe.process.ZeebeProcessInstanceRecordDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskDataDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskRecordDto;
import io.camunda.optimize.exception.OptimizeIntegrationTestException;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceImportService;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeUserTaskImportService;
import io.camunda.optimize.test.it.extension.IntegrationTestConfigurationUtil;
import io.camunda.optimize.test.it.extension.ZeebeExtension;
import io.camunda.optimize.test.it.extension.db.TermsQueryContainer;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.io.InputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.springframework.test.context.ActiveProfiles;

@Tag(value="ccsm-test")
@ActiveProfiles(value={"ccsm"})
public abstract class AbstractCCSMIT
extends AbstractIT {
    @RegisterExtension
    @Order(value=4)
    protected static ZeebeExtension zeebeExtension = new ZeebeExtension();
    protected final Supplier<OptimizeIntegrationTestException> eventNotFoundExceptionSupplier = () -> new OptimizeIntegrationTestException("Cannot find exported event");

    protected static boolean isZeebeVersionPre83() {
        Pattern zeebeVersionPattern = Pattern.compile("8.0.*|8.1.*|8.2.*");
        return zeebeVersionPattern.matcher(IntegrationTestConfigurationUtil.getZeebeDockerVersion()).matches();
    }

    public static boolean isZeebeVersionPre85() {
        Pattern zeebeVersionPattern = Pattern.compile("8.0.*|8.1.*|8.2.*|8.3.*|8.4.*");
        return zeebeVersionPattern.matcher(IntegrationTestConfigurationUtil.getZeebeDockerVersion()).matches();
    }

    public static boolean isZeebeVersionPre86() {
        Pattern zeebeVersionPattern = Pattern.compile("8.2.*|8.3.*|8.4.*|8.5.*");
        return zeebeVersionPattern.matcher(IntegrationTestConfigurationUtil.getZeebeDockerVersion()).matches();
    }

    protected static boolean isZeebeVersion87_OrLater() {
        Pattern zeebeVersionPattern = Pattern.compile("8.([7-9]|\\d{2,})");
        return zeebeVersionPattern.matcher(IntegrationTestConfigurationUtil.getZeebeDockerVersion()).matches() || AbstractCCSMIT.isZeebeVersionSnapshot();
    }

    protected static boolean isZeebeVersionSnapshot() {
        String dockerVersion = IntegrationTestConfigurationUtil.getZeebeDockerVersion();
        return dockerVersion.equalsIgnoreCase("snapshot");
    }

    protected static boolean isZeebeVersionWithMultiTenancy() {
        return !AbstractCCSMIT.isZeebeVersionPre83();
    }

    @BeforeEach
    public void setupZeebeImportAndReloadConfiguration() {
        String embeddedZeebePrefix = zeebeExtension.getZeebeRecordPrefix();
        embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().setName(embeddedZeebePrefix);
        embeddedOptimizeExtension.reloadConfiguration();
    }

    @AfterEach
    public void after() {
        databaseIntegrationTestExtension.deleteAllZeebeRecordsForPrefix(zeebeExtension.getZeebeRecordPrefix());
    }

    @Override
    protected void startAndUseNewOptimizeInstance() {
        this.startAndUseNewOptimizeInstance(new HashMap<String, String>(), "ccsm");
    }

    protected void importAllZeebeEntitiesFromScratch() {
        embeddedOptimizeExtension.importAllZeebeEntitiesFromScratch();
        databaseIntegrationTestExtension.refreshAllOptimizeIndices();
    }

    protected void importAllZeebeEntitiesFromLastIndex() {
        embeddedOptimizeExtension.importAllZeebeEntitiesFromLastIndex();
        databaseIntegrationTestExtension.refreshAllOptimizeIndices();
    }

    protected ProcessInstanceEvent deployAndStartInstanceForProcess(BpmnModelInstance process) {
        Process deployedProcess = zeebeExtension.deployProcess(process);
        return zeebeExtension.startProcessInstanceForProcess(deployedProcess.getBpmnProcessId());
    }

    protected TermsQueryContainer getQueryForProcessableProcessInstanceEvents() {
        TermsQueryContainer termsQueryContainer = new TermsQueryContainer();
        termsQueryContainer.addTermQuery("intent", ZeebeProcessInstanceImportService.INTENTS_TO_IMPORT.stream().map(Enum::name).toList());
        return termsQueryContainer;
    }

    protected String getConfiguredZeebeName() {
        return embeddedOptimizeExtension.getConfigurationService().getConfiguredZeebe().getName();
    }

    protected void waitUntilMinimumDataExportedCount(int minExportedEventCount, String indexName, TermsQueryContainer boolQueryBuilder) {
        this.waitUntilMinimumDataExportedCount(minExportedEventCount, indexName, boolQueryBuilder, 15L);
    }

    protected void waitUntilMinimumProcessInstanceEventsExportedCount(int minExportedEventCount) {
        this.waitUntilMinimumDataExportedCount(minExportedEventCount, "process-instance", this.getQueryForProcessableProcessInstanceEvents());
    }

    protected void waitUntilNumberOfDefinitionsExported(int expectedDefinitionsCount) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("intent", List.of(ProcessIntent.CREATED.name()));
        this.waitUntilMinimumDataExportedCount(expectedDefinitionsCount, "process", query);
    }

    protected void waitUntilRecordMatchingQueryExported(String indexName, TermsQueryContainer boolQuery) {
        this.waitUntilRecordMatchingQueryExported(1L, indexName, boolQuery);
    }

    protected void waitUntilRecordMatchingQueryExported(long minRecordCount, String indexName, TermsQueryContainer boolQuery) {
        this.waitUntilMinimumDataExportedCount(minRecordCount, indexName, boolQuery, 10L);
    }

    protected void waitUntilInstanceRecordWithElementIdExported(String instanceElementId) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("value.elementId", instanceElementId);
        this.waitUntilRecordMatchingQueryExported("process-instance", query);
    }

    protected void waitUntilUserTaskRecordWithElementIdExported(String instanceElementId) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("value.elementId", instanceElementId);
        this.waitUntilRecordMatchingQueryExported("user-task", query);
    }

    protected void waitUntilUserTaskRecordWithIntentExported(UserTaskIntent intent) {
        this.waitUntilUserTaskRecordWithIntentExported(1L, intent);
    }

    protected void waitUntilUserTaskRecordWithIntentExported(long minRecordCount, UserTaskIntent intent) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("value.elementId", "user_task");
        query.addTermQuery("intent", intent.name());
        this.waitUntilRecordMatchingQueryExported(minRecordCount, "user-task", query);
    }

    protected void waitUntilDefinitionWithIdExported(String processDefinitionId) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("intent", ProcessIntent.CREATED.name());
        query.addTermQuery("value.bpmnProcessId", processDefinitionId);
        this.waitUntilRecordMatchingQueryExported("process", query);
    }

    protected String getFlowNodeInstanceIdFromProcessInstanceForActivity(ProcessInstanceDto processInstanceDto, String activityId) {
        return this.getPropertyIdFromProcessInstanceForActivity(processInstanceDto, activityId, FlowNodeInstanceDto::getFlowNodeInstanceId);
    }

    protected String getPropertyIdFromProcessInstanceForActivity(ProcessInstanceDto processInstanceDto, String activityId, Function<FlowNodeInstanceDto, String> propertyFunction) {
        return processInstanceDto.getFlowNodeInstances().stream().filter(flowNodeInstanceDto -> flowNodeInstanceDto.getFlowNodeId().equals(activityId)).map(propertyFunction).findFirst().orElseThrow(() -> new OptimizeIntegrationTestException("Could not find property for process instance with key: " + processInstanceDto.getProcessDefinitionKey()));
    }

    protected BpmnModelInstance readProcessDiagramAsInstance(String diagramPath) {
        InputStream inputStream = AbstractCCSMIT.class.getResourceAsStream(diagramPath);
        return Bpmn.readModelFromStream((InputStream)inputStream);
    }

    protected void setTenantIdForExportedZeebeRecords(String indexName, String tenantId) {
        databaseIntegrationTestExtension.updateZeebeRecordsForPrefix(zeebeExtension.getZeebeRecordPrefix(), indexName, String.format("ctx._source.value.tenantId = \"%s\";", tenantId));
    }

    protected void waitUntilMinimumDataExportedCount(long minimumCount, String indexName, TermsQueryContainer queryContainer, long countTimeoutInSeconds) {
        String expectedIndex = zeebeExtension.getZeebeRecordPrefix() + "-" + indexName;
        Awaitility.given().ignoreExceptions().timeout(15L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((boolean)databaseIntegrationTestExtension.zeebeIndexExists(expectedIndex)).isTrue());
        Awaitility.given().ignoreExceptions().timeout(countTimeoutInSeconds, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((long)databaseIntegrationTestExtension.countRecordsByQuery(queryContainer, expectedIndex)).isGreaterThanOrEqualTo(minimumCount));
    }

    protected Map<String, List<ZeebeUserTaskRecordDto>> getZeebeExportedUserTaskEventsByElementId() {
        return this.getZeebeExportedProcessableEvents(zeebeExtension.getZeebeRecordPrefix() + "-user-task", this.getQueryForProcessableUserTaskEvents(), ZeebeUserTaskRecordDto.class).stream().collect(Collectors.groupingBy(event -> ((ZeebeUserTaskDataDto)event.getValue()).getElementId()));
    }

    protected Map<String, List<ZeebeProcessInstanceRecordDto>> getZeebeExportedProcessInstanceEventsByElementId() {
        return this.getZeebeExportedProcessableEvents(zeebeExtension.getZeebeRecordPrefix() + "-process-instance", this.getQueryForProcessableProcessInstanceEvents(), ZeebeProcessInstanceRecordDto.class).stream().collect(Collectors.groupingBy(event -> ((ZeebeProcessInstanceDataDto)event.getValue()).getElementId()));
    }

    protected OffsetDateTime getTimestampForFirstZeebeEventsWithIntent(List<? extends ZeebeRecordDto> eventsForElement, Intent intent) {
        ZeebeRecordDto startOfElement = eventsForElement.stream().filter(event -> event.getIntent().equals((Object)intent)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    protected OffsetDateTime getTimestampForLastZeebeEventsWithIntent(List<? extends ZeebeRecordDto> eventsForElement, Intent intent) {
        ZeebeRecordDto startOfElement = eventsForElement.stream().filter(event -> event.getIntent().equals((Object)intent)).sorted(Comparator.comparing(ZeebeRecordDto::getTimestamp)).reduce((first, second) -> second).orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    protected OffsetDateTime getTimestampForZeebeAssignEvents(List<? extends ZeebeRecordDto> eventsForElement, String assigneeId) {
        ZeebeRecordDto startOfElement = eventsForElement.stream().filter(event -> event.getIntent().equals((Object)UserTaskIntent.ASSIGNED) && ((ZeebeUserTaskDataDto)((ZeebeUserTaskRecordDto)event).getValue()).getAssignee().equals(assigneeId)).findFirst().orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    protected OffsetDateTime getTimestampForZeebeLastAssignedEvents(List<? extends ZeebeRecordDto> eventsForElement, String assigneeId) {
        ZeebeRecordDto startOfElement = eventsForElement.stream().filter(event -> event.getIntent().equals((Object)UserTaskIntent.ASSIGNED) && ((ZeebeUserTaskDataDto)((ZeebeUserTaskRecordDto)event).getValue()).getAssignee().equals(assigneeId)).sorted(Comparator.comparing(ZeebeRecordDto::getTimestamp)).reduce((first, second) -> second).orElseThrow(this.eventNotFoundExceptionSupplier);
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startOfElement.getTimestamp()), ZoneId.systemDefault());
    }

    protected OffsetDateTime getTimestampForZeebeUnassignEvent(List<? extends ZeebeRecordDto> eventsForElement) {
        return this.getTimestampForZeebeAssignEvents(eventsForElement, "");
    }

    private <T> List<T> getZeebeExportedProcessableEvents(String exportIndex, TermsQueryContainer queryForProcessableEvents, Class<T> zeebeRecordClass) {
        return databaseIntegrationTestExtension.getZeebeExportedRecordsByQuery(exportIndex, queryForProcessableEvents, zeebeRecordClass);
    }

    private TermsQueryContainer getQueryForProcessableUserTaskEvents() {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("intent", ZeebeUserTaskImportService.INTENTS_TO_IMPORT.stream().map(Enum::name).toList());
        return query;
    }

    protected void waitUntilInstanceRecordWithElementTypeAndIntentExported(BpmnElementType elementType, Intent intent) {
        TermsQueryContainer query = new TermsQueryContainer();
        query.addTermQuery("value.bpmnElementType", elementType.name());
        query.addTermQuery("intent", intent.name().toUpperCase());
        this.waitUntilMinimumDataExportedCount(1L, "process-instance", query, 10L);
    }
}

