/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import com.google.common.collect.ImmutableList;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OptimizeResourceConstants
implements ConfigurationReloadable {
    public static final String REST_API_PATH = "/api";
    public static final String INDEX_PAGE = "/";
    public static final String INDEX_HTML_PAGE = "/index.html";
    public static final String STATIC_RESOURCE_PATH = "/static";
    public static final ImmutableList<String> NO_CACHE_RESOURCES = ImmutableList.builder().add((Object)"/").add((Object)"/index.html").build();
    public static final String ACTUATOR_PORT_PROPERTY_KEY = "management.server.port";
    public static final String ACTUATOR_PORT_DEFAULT = "9600";
    public static String ACTUATOR_ENDPOINT;
    public static int ACTUATOR_PORT;

    @Value(value="${management.endpoints.web.base-path:/actuator}")
    public void setActuatorEndpointStatic(String endpoint) {
        ACTUATOR_ENDPOINT = endpoint;
    }

    @Value(value="${management.server.port:9600}")
    public void setActuatorPortStatic(int port) {
        ACTUATOR_PORT = port;
    }

    public void reloadConfiguration(ApplicationContext context) {
        String configuredPort = context.getEnvironment().getProperty(ACTUATOR_PORT_PROPERTY_KEY, ACTUATOR_PORT_DEFAULT);
        try {
            this.setActuatorPortStatic(Integer.parseInt(configuredPort));
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Cannot reload Actuator config as port is not valid: " + configuredPort);
        }
    }
}

