/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.tomcat;

import io.camunda.optimize.tomcat.ExternalResourcesUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CCSMRequestAdjustmentFilter
implements Filter {
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if ((requestURI = ExternalResourcesUtil.stripContextPath(requestURI, httpRequest)).startsWith("/external/api/")) {
            String rewrittenURI = requestURI.replaceFirst("/external/api/", "/api/external/");
            RequestDispatcher dispatcher = request.getRequestDispatcher(rewrittenURI);
            dispatcher.forward(request, response);
            return;
        }
        if (ExternalResourcesUtil.shouldServeStaticResource(httpRequest)) {
            ExternalResourcesUtil.serveStaticResource(httpRequest, httpResponse, this.servletContext);
            return;
        }
        chain.doFilter(request, response);
    }
}

