/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.variable;

import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableReportValuesRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValueRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValuesQueryDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.ProcessVariableReader;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.util.tenant.DataSourceTenantAuthorizationService;
import io.camunda.optimize.service.util.ValidationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessVariableService.class);
    private final ProcessVariableReader processVariableReader;
    private final DataSourceTenantAuthorizationService tenantAuthorizationService;
    private final ReportService reportService;

    public ProcessVariableService(ProcessVariableReader processVariableReader, DataSourceTenantAuthorizationService tenantAuthorizationService, ReportService reportService) {
        this.processVariableReader = processVariableReader;
        this.tenantAuthorizationService = tenantAuthorizationService;
        this.reportService = reportService;
    }

    public List<ProcessVariableNameResponseDto> getVariableNames(ProcessVariableNameRequestDto variableRequestDto) {
        return this.processVariableReader.getVariableNames(variableRequestDto);
    }

    public List<ProcessVariableNameResponseDto> getVariableNamesForReports(List<String> reportIds) {
        List processesToQuery = this.convertReportsToVariableQuery(this.reportService.getAllReportsForIds(reportIds), this::convertToProcessToQueryDto);
        ProcessVariableNameRequestDto processVariableNameRequestDto = new ProcessVariableNameRequestDto(processesToQuery);
        return this.processVariableReader.getVariableNames(processVariableNameRequestDto);
    }

    public List<ProcessVariableNameResponseDto> getVariableNamesForAuthorizedReports(String userId, List<String> reportIds) {
        List processesToQuery = this.convertAuthorizedReportsToVariableQuery(userId, reportIds, this::convertToProcessToQueryDto);
        ProcessVariableNameRequestDto processVariableNameRequestDto = new ProcessVariableNameRequestDto(processesToQuery);
        return this.processVariableReader.getVariableNames(processVariableNameRequestDto);
    }

    public List<ProcessVariableNameResponseDto> getVariableNamesForReportDefinitions(List<SingleProcessReportDefinitionRequestDto> definitions) {
        List processesToQuery = definitions.stream().filter(definition -> ((ProcessReportDataDto)definition.getData()).getProcessDefinitionKey() != null).map(this::convertToProcessToQueryDto).flatMap(Collection::stream).toList();
        ProcessVariableNameRequestDto processVariableNameRequestDto = new ProcessVariableNameRequestDto(processesToQuery);
        return this.processVariableReader.getVariableNames(processVariableNameRequestDto);
    }

    public List<String> getVariableValues(String userId, ProcessVariableValueRequestDto requestDto) {
        ValidationHelper.ensureNotEmpty("process definition key", requestDto.getProcessDefinitionKey());
        ValidationHelper.ensureNotEmpty("variable name", requestDto.getName());
        ValidationHelper.ensureNotEmpty("variable type", requestDto.getType());
        if (!this.tenantAuthorizationService.isAuthorizedToSeeAllTenants(userId, IdentityType.USER, requestDto.getTenantIds())) {
            throw new ForbiddenException("Current user is not authorized to access data of all provided tenants");
        }
        if (requestDto.getProcessDefinitionVersions().isEmpty()) {
            return Collections.emptyList();
        }
        return this.processVariableReader.getVariableValues(ProcessVariableValuesQueryDto.fromProcessVariableValueRequestDto((ProcessVariableValueRequestDto)requestDto));
    }

    public List<String> getVariableValuesForReports(String userId, ProcessVariableReportValuesRequestDto requestDto) {
        ValidationHelper.ensureNotEmpty("report IDs", requestDto.getReportIds());
        ValidationHelper.ensureNotEmpty("variable name", requestDto.getName());
        ValidationHelper.ensureNotEmpty("variable type", requestDto.getType());
        List<ReportDefinitionDto> authorizedReports = this.getAllAuthorizedReportsRecursively(userId, requestDto.getReportIds());
        return this.processVariableReader.getVariableValues(ProcessVariableValuesQueryDto.fromProcessVariableReportValuesRequest((ProcessVariableReportValuesRequestDto)requestDto, authorizedReports));
    }

    private <T> List<T> convertReportsToVariableQuery(List<ReportDefinitionDto> reportDefinitions, Function<SingleReportDefinitionDto<?>, List<T>> mappingFunction) {
        ArrayList<ReportDefinitionDto> allReportsForIds = new ArrayList<ReportDefinitionDto>(reportDefinitions);
        allReportsForIds.addAll(allReportsForIds.stream().filter(reportDefinitionDto -> reportDefinitionDto instanceof CombinedReportDefinitionRequestDto).flatMap(combinedReport -> {
            List reportIdsFromCombined = ((CombinedReportDataDto)((CombinedReportDefinitionRequestDto)combinedReport).getData()).getReportIds();
            return this.reportService.getAllReportsForIds(reportIdsFromCombined).stream();
        }).collect(Collectors.toList()));
        return this.convertReportsToVariableQuery(mappingFunction, allReportsForIds);
    }

    private <T> List<T> convertAuthorizedReportsToVariableQuery(String userId, List<String> reportIds, Function<SingleReportDefinitionDto<?>, List<T>> mappingFunction) {
        List<ReportDefinitionDto> allAuthorizedReportsForIds = this.getAllAuthorizedReportsRecursively(userId, reportIds);
        return this.convertReportsToVariableQuery(mappingFunction, allAuthorizedReportsForIds);
    }

    private List<ReportDefinitionDto> getAllAuthorizedReportsRecursively(String userId, List<String> reportIds) {
        List<ReportDefinitionDto> allAuthorizedReportsForIds = this.reportService.getAllAuthorizedReportsForIds(userId, reportIds);
        allAuthorizedReportsForIds.addAll(allAuthorizedReportsForIds.stream().filter(CombinedReportDefinitionRequestDto.class::isInstance).flatMap(combinedReport -> {
            List reportIdsFromCombined = ((CombinedReportDataDto)((CombinedReportDefinitionRequestDto)combinedReport).getData()).getReportIds();
            return Optional.ofNullable(userId).map(user -> this.reportService.getAllAuthorizedReportsForIds(userId, reportIdsFromCombined).stream()).orElse(this.reportService.getAllReportsForIds(reportIdsFromCombined).stream());
        }).collect(Collectors.toList()));
        return allAuthorizedReportsForIds;
    }

    private <T> List<T> convertReportsToVariableQuery(Function<SingleReportDefinitionDto<?>, List<T>> mappingFunction, List<ReportDefinitionDto> reportDefinitionDtos) {
        return reportDefinitionDtos.stream().distinct().filter(SingleReportDefinitionDto.class::isInstance).map(definition -> (SingleReportDefinitionDto)definition).map(mappingFunction).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ProcessToQueryDto> convertToProcessToQueryDto(SingleReportDefinitionDto<?> reportDefinitionDto) {
        return ((SingleReportDataDto)reportDefinitionDto.getData()).getDefinitions().stream().map(definitionDto -> {
            ProcessToQueryDto processToQuery = new ProcessToQueryDto();
            processToQuery.setProcessDefinitionKey(definitionDto.getKey());
            processToQuery.setProcessDefinitionVersions(definitionDto.getVersions());
            processToQuery.setTenantIds(Optional.ofNullable(definitionDto.getTenantIds()).orElse(ReportConstants.DEFAULT_TENANT_IDS));
            return processToQuery;
        }).collect(Collectors.toList());
    }
}

