/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.util;

import com.github.sisyphsu.dateparser.DateParserUtils;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public final class DateFormatterUtil {
    private static final DateTimeFormatter OPTIMIZE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private DateFormatterUtil() {
    }

    public static boolean isValidOptimizeDateFormat(String value) {
        try {
            OffsetDateTime.parse(value, OPTIMIZE_FORMATTER);
            return true;
        }
        catch (DateTimeParseException ex) {
            return false;
        }
    }

    public static Optional<String> getDateStringInOptimizeDateFormat(String dateString) {
        try {
            OffsetDateTime parsedOffsetDateTime = DateParserUtils.parseOffsetDateTime((String)dateString);
            return Optional.of(parsedOffsetDateTime.format(OPTIMIZE_FORMATTER));
        }
        catch (DateTimeParseException ex) {
            return Optional.empty();
        }
    }

    public static Optional<OffsetDateTime> getOffsetDateTimeFromIsoZoneDateTimeString(String dateString) {
        try {
            return Optional.of(ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME).toOffsetDateTime());
        }
        catch (DateTimeParseException ex) {
            return Optional.empty();
        }
    }
}

