/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.tenant;

import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.security.util.tenant.CamundaCCSMTenantAuthorizationService;
import io.camunda.optimize.service.tenant.TenantService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSMCondition.class})
public class CamundaCCSMTenantService
implements TenantService {
    private final CamundaCCSMTenantAuthorizationService tenantAuthorizationService;
    private final ConfigurationService configurationService;

    public CamundaCCSMTenantService(CamundaCCSMTenantAuthorizationService tenantAuthorizationService, ConfigurationService configurationService) {
        this.tenantAuthorizationService = tenantAuthorizationService;
        this.configurationService = configurationService;
    }

    @Override
    public boolean isAuthorizedToSeeTenant(String userId, String tenantId) {
        return this.tenantAuthorizationService.isAuthorizedToSeeTenant(userId, IdentityType.USER, tenantId);
    }

    @Override
    public boolean isMultiTenantEnvironment() {
        return this.configurationService.isMultiTenancyEnabled();
    }

    @Override
    public List<TenantDto> getTenantsForUser(String userId) {
        return this.getTenantsForCurrentUser();
    }

    private List<TenantDto> getTenantsForCurrentUser() {
        return this.tenantAuthorizationService.getCurrentUserAuthorizedTenants();
    }
}

