/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security.util.definition;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import io.camunda.optimize.service.security.util.tenant.CamundaCCSMTenantAuthorizationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={CCSMCondition.class})
@Component
public class CamundaCCSMDefinitionAuthorizationService
implements DataSourceDefinitionAuthorizationService {
    private final CamundaCCSMTenantAuthorizationService tenantAuthorizationService;

    public CamundaCCSMDefinitionAuthorizationService(CamundaCCSMTenantAuthorizationService tenantAuthorizationService) {
        this.tenantAuthorizationService = tenantAuthorizationService;
    }

    @Override
    public boolean isAuthorizedToAccessDefinition(String identityId, IdentityType identityType, String definitionKey, DefinitionType definitionType, List<String> tenantIds) {
        return StringUtils.isBlank((CharSequence)definitionKey) || this.tenantAuthorizationService.isAuthorizedToSeeAllTenants(identityId, identityType, tenantIds);
    }

    @Override
    public List<TenantDto> resolveAuthorizedTenantsForProcess(String userId, SimpleDefinitionDto definitionDto, List<String> tenantIds, Set<String> engines) {
        Map<String, TenantDto> allUserAuthorizedTenants = this.tenantAuthorizationService.getCurrentUserTenantAuthorizations();
        return tenantIds.stream().map(allUserAuthorizedTenants::get).filter(Objects::nonNull).sorted(Comparator.comparing(TenantDto::getId, Comparator.naturalOrder())).toList();
    }

    @Override
    public boolean isAuthorizedToAccessDefinition(String userId, String tenantId, SimpleDefinitionDto definition) {
        return this.tenantAuthorizationService.isAuthorizedToSeeTenant(userId, IdentityType.USER, tenantId);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> boolean isAuthorizedToAccessDefinition(String userId, T definition) {
        return this.tenantAuthorizationService.isAuthorizedToSeeTenant(userId, IdentityType.USER, definition.getTenantId());
    }
}

