/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ShareSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ShareSearchResultResponseDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.db.reader.SharingReader;
import io.camunda.optimize.service.db.report.PlainReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.db.writer.SharingWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.evaluation.ReportEvaluationException;
import io.camunda.optimize.service.relations.DashboardReferencingService;
import io.camunda.optimize.service.relations.ReportReferencingService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SharingService
implements ReportReferencingService,
DashboardReferencingService {
    private static final Logger LOG = LoggerFactory.getLogger(SharingService.class);
    private final SharingWriter sharingWriter;
    private final SharingReader sharingReader;
    private final PlainReportEvaluationHandler reportEvaluationHandler;
    private final DashboardService dashboardService;
    private final ReportService reportService;

    public SharingService(SharingWriter sharingWriter, SharingReader sharingReader, PlainReportEvaluationHandler reportEvaluationHandler, DashboardService dashboardService, ReportService reportService) {
        this.sharingWriter = sharingWriter;
        this.sharingReader = sharingReader;
        this.reportEvaluationHandler = reportEvaluationHandler;
        this.dashboardService = dashboardService;
        this.reportService = reportService;
    }

    public IdResponseDto createNewReportShareIfAbsent(ReportShareRestDto createSharingDto, String userId) {
        this.validateAndCheckAuthorization(createSharingDto, userId);
        Optional<ReportShareRestDto> existing = this.sharingReader.findShareForReport(createSharingDto.getReportId());
        return existing.map(share -> new IdResponseDto(share.getId())).orElseGet(() -> this.createNewReportShare(createSharingDto));
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportDelete(ReportDefinitionDto reportDefinition) {
        return Collections.emptySet();
    }

    @Override
    public void handleReportDeleted(ReportDefinitionDto reportDefinition) {
        this.deleteShareForReport(reportDefinition.getId());
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportUpdate(ReportDefinitionDto currentDefinition, ReportDefinitionDto updateDefinition) {
        return Collections.emptySet();
    }

    @Override
    public void handleReportUpdated(String reportId, ReportDefinitionDto updateDefinition) {
    }

    @Override
    public void handleDashboardDeleted(DashboardDefinitionRestDto definition) {
        this.deleteShareForDashboard(definition.getId());
    }

    @Override
    public void handleDashboardUpdated(DashboardDefinitionRestDto updatedDashboard) {
        Optional<DashboardShareRestDto> dashboardShare = this.findShareForDashboard(updatedDashboard.getId());
        dashboardShare.ifPresent(share -> {
            share.setTileShares(updatedDashboard.getTiles());
            this.sharingWriter.updateDashboardShare((DashboardShareRestDto)share);
        });
    }

    private IdResponseDto createNewReportShare(ReportShareRestDto createSharingDto) {
        String result = this.sharingWriter.saveReportShare(createSharingDto).getId();
        return new IdResponseDto(result);
    }

    public IdResponseDto createNewDashboardShare(DashboardShareRestDto createSharingDto, String userId) {
        this.validateAndCheckAuthorization(createSharingDto.getDashboardId(), userId);
        Optional<DashboardShareRestDto> existing = this.sharingReader.findShareForDashboard(createSharingDto.getDashboardId());
        String result = existing.map(DashboardShareRestDto::getId).orElseGet(() -> {
            this.addReportInformation(createSharingDto, userId);
            return this.sharingWriter.saveDashboardShare(createSharingDto).getId();
        });
        return new IdResponseDto(result);
    }

    private void addReportInformation(DashboardShareRestDto createSharingDto, String userId) {
        DashboardDefinitionRestDto dashboardDefinition = this.dashboardService.getDashboardDefinition(createSharingDto.getDashboardId(), userId).getDefinitionDto();
        createSharingDto.setTileShares(dashboardDefinition.getTiles());
    }

    public void validateAndCheckAuthorization(String dashboardId, String userId) {
        ValidationHelper.ensureNotEmpty("dashboardId", dashboardId);
        try {
            DashboardDefinitionRestDto dashboardDefinition = this.dashboardService.getDashboardDefinition(dashboardId, userId).getDefinitionDto();
            if (dashboardDefinition.isManagementDashboard() || dashboardDefinition.isInstantPreviewDashboard()) {
                throw new OptimizeValidationException("Management Dashboards or Instant preview dashboards cannot be shared");
            }
            Set<String> authorizedReportIdsOnDashboard = this.reportService.filterAuthorizedReportIds(userId, dashboardDefinition.getTileIds());
            HashSet unauthorizedReportIds = new HashSet(dashboardDefinition.getTileIds());
            unauthorizedReportIds.removeAll(authorizedReportIdsOnDashboard);
            if (!unauthorizedReportIds.isEmpty()) {
                String errorMessage = "User [" + userId + "] is not authorized to share dashboard [" + dashboardDefinition.getName() + "] because they are not authorized to see contained report(s) [" + String.valueOf(unauthorizedReportIds) + "]";
                throw new ForbiddenException(errorMessage);
            }
        }
        catch (OptimizeValidationException exception) {
            throw exception;
        }
        catch (NotFoundException | OptimizeRuntimeException e) {
            String errorMessage = "Could not retrieve dashboard [" + dashboardId + "]. It probably does not exist.";
            throw new OptimizeRuntimeException(errorMessage, e);
        }
    }

    private void validateAndCheckAuthorization(ReportShareRestDto reportShare, String userId) {
        ValidationHelper.ensureNotEmpty("reportId", reportShare.getReportId());
        try {
            ProcessReportDataDto reportData;
            AuthorizedReportDefinitionResponseDto reportDefinition = this.reportService.getReportDefinition(reportShare.getReportId(), userId);
            if (reportDefinition.getDefinitionDto() instanceof SingleProcessReportDefinitionRequestDto && ((reportData = (ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinition.getDefinitionDto()).getData()).isManagementReport() || reportData.isInstantPreviewReport())) {
                throw new OptimizeValidationException("Management Reports and Instant preview dashboard Reports cannot be shared");
            }
        }
        catch (OptimizeValidationException exception) {
            throw exception;
        }
        catch (NotFoundException | OptimizeRuntimeException e) {
            String errorMessage = "Could not retrieve report [" + reportShare.getReportId() + "]. It probably does not exist.";
            throw new OptimizeRuntimeException(errorMessage, e);
        }
    }

    public void deleteReportShare(String shareId) {
        this.sharingWriter.deleteReportShare(shareId);
    }

    public void deleteDashboardShare(String shareId) {
        this.sharingWriter.deleteDashboardShare(shareId);
    }

    public AuthorizedReportEvaluationResult evaluateReportShare(String shareId, ZoneId timezone, PaginationDto paginationDto) {
        Optional<ReportShareRestDto> optionalReportShare = this.sharingReader.getReportShare(shareId);
        return optionalReportShare.map(share -> this.evaluateReport(ReportEvaluationInfo.builder(share.getReportId()).timezone(timezone).pagination(paginationDto).isSharedReport(true).build())).orElseThrow(() -> new OptimizeRuntimeException("share [" + shareId + "] does not exist or is of unsupported type"));
    }

    public AuthorizedReportEvaluationResult evaluateReportForSharedDashboard(String dashboardShareId, String reportId, ZoneId timezone, AdditionalProcessReportEvaluationFilterDto reportEvaluationFilter, PaginationDto paginationDto) {
        DashboardDefinitionRestDto dashboard = this.sharingReader.findDashboardShare(dashboardShareId).map(share -> this.dashboardService.getDashboardDefinitionAsService(share.getDashboardId())).orElseThrow(() -> new OptimizeRuntimeException(String.format("Could not find dashboard share for id [%s]", dashboardShareId)));
        boolean dashboardContainsReport = dashboard.getTiles().stream().anyMatch(r -> Objects.equals(r.getId(), reportId));
        if (!dashboardContainsReport) {
            String reason = "Cannot evaluate report [" + reportId + "] for shared dashboard id [" + dashboardShareId + "]. Given report is not contained in dashboard.";
            LOG.error(reason);
            throw new OptimizeRuntimeException(reason);
        }
        return this.evaluateReport(ReportEvaluationInfo.builder(reportId).timezone(timezone).additionalFilters(reportEvaluationFilter).pagination(paginationDto).isSharedReport(true).build());
    }

    public AuthorizedReportEvaluationResult evaluateReport(ReportEvaluationInfo evaluationInfo) {
        try {
            return this.reportEvaluationHandler.evaluateReport(evaluationInfo);
        }
        catch (ReportEvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException("Cannot evaluate shared report [" + evaluationInfo.getReportId() + "].", (Throwable)e);
        }
    }

    public Optional<DashboardDefinitionRestDto> evaluateDashboard(String shareId) {
        Optional<DashboardShareRestDto> sharedDashboard = this.sharingReader.findDashboardShare(shareId);
        return sharedDashboard.map(this::constructDashboard).orElseThrow(() -> new OptimizeRuntimeException("dashboard share [" + shareId + "] does not exist or is of unsupported type"));
    }

    private Optional<DashboardDefinitionRestDto> constructDashboard(DashboardShareRestDto share) {
        DashboardDefinitionRestDto result = this.dashboardService.getDashboardDefinitionAsService(share.getDashboardId());
        return Optional.of(result);
    }

    private void deleteShareForReport(String reportId) {
        this.findShareForReport(reportId).ifPresent(dto -> this.deleteReportShare(dto.getId()));
    }

    private void deleteShareForDashboard(String dashboardId) {
        this.findShareForDashboard(dashboardId).ifPresent(dto -> this.deleteDashboardShare(dto.getId()));
    }

    public Optional<ReportShareRestDto> findShareForReport(String resourceId) {
        return this.sharingReader.findShareForReport(resourceId);
    }

    public Optional<DashboardShareRestDto> findShareForDashboard(String resourceId) {
        return this.sharingReader.findShareForDashboard(resourceId);
    }

    public ShareSearchResultResponseDto checkShareStatus(ShareSearchRequestDto searchRequest) {
        Map<String, Object> shareForReports;
        ShareSearchResultResponseDto result = new ShareSearchResultResponseDto();
        if (searchRequest != null && searchRequest.getReports() != null && !searchRequest.getReports().isEmpty()) {
            shareForReports = this.sharingReader.findShareForReports(searchRequest.getReports());
            for (String reportId : searchRequest.getReports()) {
                result.getReports().put(reportId, shareForReports.containsKey(reportId));
            }
        }
        if (searchRequest != null && searchRequest.getDashboards() != null && !searchRequest.getDashboards().isEmpty()) {
            shareForReports = this.sharingReader.findShareForDashboards(searchRequest.getDashboards());
            for (String dashboardId : searchRequest.getDashboards()) {
                result.getDashboards().put(dashboardId, shareForReports.containsKey(dashboardId));
            }
        }
        return result;
    }
}

