/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.security;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.collection.CollectionEntity;
import io.camunda.optimize.dto.optimize.query.entity.EntityResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.service.db.reader.EntitiesReader;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.security.ReportAuthorizationService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

@Component
public class AuthorizedEntitiesService {
    private final EntitiesReader entitiesReader;
    private final AbstractIdentityService identityService;
    private final ReportAuthorizationService reportAuthorizationService;

    public AuthorizedEntitiesService(EntitiesReader entitiesReader, AbstractIdentityService identityService, ReportAuthorizationService reportAuthorizationService) {
        this.entitiesReader = entitiesReader;
        this.identityService = identityService;
        this.reportAuthorizationService = reportAuthorizationService;
    }

    public List<EntityResponseDto> getAuthorizedPrivateEntities(String userId) {
        List<CollectionEntity> collectionEntities = this.entitiesReader.getAllPrivateEntitiesForOwnerId(userId);
        RoleType roleForUser = this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.ENTITY_EDITOR) ? RoleType.EDITOR : RoleType.VIEWER;
        return collectionEntities.stream().map(collectionEntity -> Pair.of((Object)collectionEntity, (Object)collectionEntity.toEntityDto(roleForUser))).filter(collectionEntityAndEntityDto -> {
            EntityResponseDto entityDto = (EntityResponseDto)collectionEntityAndEntityDto.getValue();
            if (entityDto.getEntityType().equals((Object)EntityType.REPORT)) {
                return this.reportAuthorizationService.isAuthorizedToAccessReportDefinition(userId, (ReportDefinitionDto)collectionEntityAndEntityDto.getKey());
            }
            return true;
        }).map(Pair::getValue).collect(Collectors.toList());
    }

    public List<EntityResponseDto> getAuthorizedCollectionEntities(String userId, String collectionId) {
        return this.entitiesReader.getAllEntitiesForCollection(collectionId).stream().map(collectionEntity -> Pair.of((Object)collectionEntity, (Object)collectionEntity.toEntityDto(RoleType.EDITOR))).filter(collectionEntityAndEntityDto -> {
            EntityResponseDto entityDto = (EntityResponseDto)collectionEntityAndEntityDto.getValue();
            if (entityDto.getEntityType().equals((Object)EntityType.REPORT)) {
                return this.reportAuthorizationService.isAuthorizedToAccessReportDefinition(userId, (ReportDefinitionDto)collectionEntityAndEntityDto.getKey());
            }
            return true;
        }).map(Pair::getValue).collect(Collectors.toList());
    }
}

