/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.relations;

import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.service.relations.CollectionReferencingService;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CollectionRelationService {
    private final List<CollectionReferencingService> referenceServices;

    @Lazy
    public CollectionRelationService(List<CollectionReferencingService> referenceServices) {
        this.referenceServices = referenceServices;
    }

    public Set<ConflictedItemDto> getConflictedItemsForDelete(CollectionDefinitionDto definition) {
        LinkedHashSet<ConflictedItemDto> conflictedItems = new LinkedHashSet<ConflictedItemDto>();
        for (CollectionReferencingService referencingService : this.referenceServices) {
            conflictedItems.addAll(referencingService.getConflictedItemsForCollectionDelete(definition));
        }
        return conflictedItems;
    }

    public void handleDeleted(CollectionDefinitionDto definition) {
        for (CollectionReferencingService referencingService : this.referenceServices) {
            referencingService.handleCollectionDeleted(definition);
        }
    }
}

