/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.mixpanel;

import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.service.db.reader.AlertReader;
import io.camunda.optimize.service.db.reader.DashboardReader;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.reader.SharingReader;
import io.camunda.optimize.service.mixpanel.client.MixpanelEntityEventProperties;
import io.camunda.optimize.service.mixpanel.client.MixpanelHeartbeatMetrics;
import io.camunda.optimize.service.mixpanel.client.MixpanelHeartbeatProperties;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.analytics.MixpanelConfiguration;
import org.springframework.stereotype.Component;

@Component
public class MixpanelDataService {
    private final ConfigurationService configurationService;
    private final ReportReader reportReader;
    private final DashboardReader dashboardReader;
    private final AlertReader alertReader;
    private final SharingReader sharingReader;

    public MixpanelDataService(ConfigurationService configurationService, ReportReader reportReader, DashboardReader dashboardReader, AlertReader alertReader, SharingReader sharingReader) {
        this.configurationService = configurationService;
        this.reportReader = reportReader;
        this.dashboardReader = dashboardReader;
        this.alertReader = alertReader;
        this.sharingReader = sharingReader;
    }

    public MixpanelHeartbeatProperties getMixpanelHeartbeatProperties() {
        MixpanelConfiguration.TrackingProperties mixpanelProperties = this.getMixpanelProperties();
        return new MixpanelHeartbeatProperties(new MixpanelHeartbeatMetrics(this.reportReader.getReportCount(ReportType.PROCESS), this.reportReader.getReportCount(ReportType.DECISION), this.dashboardReader.getDashboardCount(), this.sharingReader.getReportShareCount(), this.sharingReader.getDashboardShareCount(), this.alertReader.getAlertCount(), this.reportReader.getUserTaskReportCount()), mixpanelProperties.getStage(), mixpanelProperties.getOrganizationId(), mixpanelProperties.getClusterId());
    }

    public MixpanelEntityEventProperties getMixpanelEntityEventProperties(String entityId) {
        MixpanelConfiguration.TrackingProperties mixpanelProperties = this.getMixpanelProperties();
        return new MixpanelEntityEventProperties(entityId, mixpanelProperties.getStage(), mixpanelProperties.getOrganizationId(), mixpanelProperties.getClusterId());
    }

    private MixpanelConfiguration.TrackingProperties getMixpanelProperties() {
        return this.configurationService.getAnalytics().getMixpanel().getProperties();
    }
}

