/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.job;

import io.camunda.optimize.dto.optimize.ImportRequestDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.DatabaseImportJob;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.List;

public class ProcessInstanceDatabaseImportJob
extends DatabaseImportJob<ProcessInstanceDto> {
    private final ProcessInstanceWriter zeebeProcessInstanceWriter;
    private final ConfigurationService configurationService;
    private final String sourceExportIndex;

    public ProcessInstanceDatabaseImportJob(ProcessInstanceWriter zeebeProcessInstanceWriter, ConfigurationService configurationService, Runnable importCompleteCallback, String sourceExportIndex, DatabaseClient databaseClient) {
        super(importCompleteCallback, databaseClient);
        this.zeebeProcessInstanceWriter = zeebeProcessInstanceWriter;
        this.configurationService = configurationService;
        this.sourceExportIndex = sourceExportIndex;
    }

    @Override
    protected void persistEntities(List<ProcessInstanceDto> processInstances) {
        List<ImportRequestDto> importRequests = this.zeebeProcessInstanceWriter.generateProcessInstanceImports(processInstances, this.sourceExportIndex);
        this.databaseClient.executeImportRequestsAsBulk("Zeebe process instances", importRequests, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }
}

