/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.mediator;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.importing.ingested.fetcher.ExternalVariableUpdateInstanceFetcher;
import io.camunda.optimize.service.importing.ingested.handler.ExternalVariableUpdateImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.service.ExternalVariableUpdateImportService;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExternalVariableUpdateImportMediator
implements ImportMediator {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalVariableUpdateImportMediator.class);
    private final ConfigurationService configurationService;
    private final BackoffCalculator idleBackoffCalculator;
    private final ExternalVariableUpdateImportIndexHandler importIndexHandler;
    private final ImportService<ExternalProcessVariableDto> importService;
    private final BackoffCalculator errorBackoffCalculator = new BackoffCalculator(10L, 1000L);
    private final ExternalVariableUpdateInstanceFetcher entityFetcher;
    private int countOfImportedEntitiesWithLastEntityTimestamp = 0;

    public ExternalVariableUpdateImportMediator(ExternalVariableUpdateImportIndexHandler importIndexHandler, ExternalVariableUpdateInstanceFetcher entityFetcher, ExternalVariableUpdateImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.entityFetcher = entityFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public CompletableFuture<Void> runImport() {
        CompletableFuture<Void> importCompleted = new CompletableFuture<Void>();
        boolean pageIsPresent = this.importNextPageRetryOnError(importCompleted);
        if (pageIsPresent) {
            this.idleBackoffCalculator.resetBackoff();
        } else {
            this.calculateNewDateUntilIsBlocked();
        }
        return importCompleted;
    }

    @Override
    public long getBackoffTimeInMs() {
        return this.idleBackoffCalculator.getTimeUntilNextRetry();
    }

    @Override
    public void resetBackoff() {
        this.idleBackoffCalculator.resetBackoff();
    }

    @Override
    public boolean canImport() {
        boolean canImportNewPage = this.idleBackoffCalculator.isReadyForNextRetry();
        LOG.debug("can import next page [{}]", (Object)canImportNewPage);
        return canImportNewPage;
    }

    @Override
    public boolean hasPendingImportJobs() {
        return this.importService.hasPendingImportJobs();
    }

    @Override
    public void shutdown() {
        this.importService.shutdown();
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.INSTANCE_SUB_ENTITIES;
    }

    private OffsetDateTime getTimestamp(ExternalProcessVariableDto historicVariableUpdateInstanceDto) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(historicVariableUpdateInstanceDto.getIngestionTimestamp()), ZoneId.systemDefault());
    }

    private List<ExternalProcessVariableDto> getEntitiesNextPage() {
        return this.entityFetcher.fetchVariableInstanceUpdates(this.importIndexHandler.getNextPage());
    }

    private List<ExternalProcessVariableDto> getEntitiesLastTimestamp() {
        return this.entityFetcher.fetchVariableInstanceUpdates(this.importIndexHandler.getTimestampOfLastEntity());
    }

    private int getMaxPageSize() {
        return this.configurationService.getExternalVariableConfiguration().getImportConfiguration().getMaxPageSize();
    }

    private boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPageTimestampBased(this.getEntitiesLastTimestamp(), this.getEntitiesNextPage(), this.getMaxPageSize(), importCompleteCallback);
    }

    private boolean importNextPageTimestampBased(List<ExternalProcessVariableDto> entitiesLastTimestamp, List<ExternalProcessVariableDto> entitiesNextPage, int maxPageSize, Runnable importCompleteCallback) {
        this.importIndexHandler.updateLastImportExecutionTimestamp();
        if (!entitiesNextPage.isEmpty()) {
            ArrayList<ExternalProcessVariableDto> allEntities = new ArrayList<ExternalProcessVariableDto>();
            if (entitiesLastTimestamp.size() > this.countOfImportedEntitiesWithLastEntityTimestamp) {
                allEntities.addAll(entitiesLastTimestamp);
            }
            allEntities.addAll(entitiesNextPage);
            OffsetDateTime currentPageLastEntityTimestamp = this.getTimestamp(entitiesNextPage.get(entitiesNextPage.size() - 1));
            this.importService.executeImport(allEntities, () -> {
                this.importIndexHandler.updateTimestampOfLastEntity(currentPageLastEntityTimestamp);
                importCompleteCallback.run();
            });
            this.countOfImportedEntitiesWithLastEntityTimestamp = (int)entitiesNextPage.stream().filter(entity -> this.getTimestamp((ExternalProcessVariableDto)entity).equals(currentPageLastEntityTimestamp)).count();
            this.importIndexHandler.updatePendingTimestampOfLastEntity(currentPageLastEntityTimestamp);
        } else if (entitiesLastTimestamp.size() > this.countOfImportedEntitiesWithLastEntityTimestamp) {
            this.countOfImportedEntitiesWithLastEntityTimestamp = entitiesLastTimestamp.size();
            this.importService.executeImport(entitiesLastTimestamp, importCompleteCallback);
        } else {
            importCompleteCallback.run();
        }
        return entitiesNextPage.size() >= maxPageSize;
    }

    private boolean importNextPageRetryOnError(CompletableFuture<Void> importCompleteCallback) {
        Boolean result = null;
        try {
            while (result == null) {
                try {
                    result = this.importNextPage(() -> importCompleteCallback.complete(null));
                }
                catch (IllegalStateException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (this.errorBackoffCalculator.isMaximumBackoffReached()) {
                        LOG.error("Was not able to import next page and reached max backoff, aborting this run.", (Throwable)e);
                        importCompleteCallback.complete(null);
                        result = true;
                        continue;
                    }
                    long timeToSleep = this.errorBackoffCalculator.calculateSleepTime();
                    LOG.error("Was not able to import next page, retrying after sleeping for {}ms.", (Object)timeToSleep, (Object)e);
                    Thread.sleep(timeToSleep);
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Was interrupted while importing next page.", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        this.errorBackoffCalculator.resetBackoff();
        return result;
    }

    private void calculateNewDateUntilIsBlocked() {
        if (this.idleBackoffCalculator.isMaximumBackoffReached()) {
            LOG.debug("Maximum idle backoff reached, this mediator will not backoff any further than {}ms.", (Object)this.idleBackoffCalculator.getMaximumBackoffMilliseconds());
        }
        long sleepTime = this.idleBackoffCalculator.calculateSleepTime();
        LOG.debug("Was not able to produce a new job, sleeping for [{}] ms", (Object)sleepTime);
    }
}

