/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.ZeebeRecordDto;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.PositionBasedImportIndexHandler;
import io.camunda.optimize.service.importing.engine.service.ImportService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.micrometer.core.instrument.Timer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PositionBasedImportMediator<T extends PositionBasedImportIndexHandler, DTO extends ZeebeRecordDto<?, ?>>
implements ImportMediator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ConfigurationService configurationService;
    protected BackoffCalculator idleBackoffCalculator;
    protected T importIndexHandler;
    protected ImportService<DTO> importService;
    private final BackoffCalculator errorBackoffCalculator = new BackoffCalculator(10L, 1000L);

    @Override
    public CompletableFuture<Void> runImport() {
        CompletableFuture<Void> importCompleted = new CompletableFuture<Void>();
        boolean pageIsPresent = this.importNextPageWithRetries(importCompleted);
        if (pageIsPresent) {
            this.idleBackoffCalculator.resetBackoff();
        } else {
            this.calculateNewDateUntilIsBlocked();
        }
        return importCompleted;
    }

    @Override
    public long getBackoffTimeInMs() {
        return this.idleBackoffCalculator.getTimeUntilNextRetry();
    }

    @Override
    public void resetBackoff() {
        this.idleBackoffCalculator.resetBackoff();
    }

    @Override
    public boolean canImport() {
        boolean canImportNewPage = this.idleBackoffCalculator.isReadyForNextRetry();
        this.logger.debug("can import next page [{}]", (Object)canImportNewPage);
        return canImportNewPage;
    }

    @Override
    public boolean hasPendingImportJobs() {
        return this.importService.hasPendingImportJobs();
    }

    @Override
    public void shutdown() {
        this.importService.shutdown();
    }

    public T getImportIndexHandler() {
        return this.importIndexHandler;
    }

    protected abstract boolean importNextPage(Runnable var1);

    private boolean importNextPageWithRetries(CompletableFuture<Void> importCompleteCallback) {
        Boolean result = null;
        while (result == null) {
            try {
                result = this.importNextPage(() -> importCompleteCallback.complete(null));
            }
            catch (Exception e) {
                if (this.errorBackoffCalculator.isMaximumBackoffReached()) {
                    this.logger.error("Was not able to import next page and reached max backoff, aborting this run.", (Throwable)e);
                    importCompleteCallback.complete(null);
                    result = true;
                    continue;
                }
                long timeToSleep = this.errorBackoffCalculator.calculateSleepTime();
                this.logger.error("Was not able to import next page, retrying after sleeping for {}ms.", (Object)timeToSleep, (Object)e);
                this.sleep(timeToSleep);
            }
        }
        this.errorBackoffCalculator.resetBackoff();
        return result;
    }

    protected boolean importNextPagePositionBased(List<DTO> entitiesNextPage, Runnable importCompleteCallback) {
        ((PositionBasedImportIndexHandler)this.importIndexHandler).updateLastImportExecutionTimestamp(LocalDateUtil.getCurrentDateTime());
        this.logger.info("Records of type {} from partition {} imported in page: {}", new Object[]{this.getRecordType(), this.getPartitionId(), entitiesNextPage.size()});
        if (!entitiesNextPage.isEmpty()) {
            ZeebeRecordDto lastImportedEntity = (ZeebeRecordDto)entitiesNextPage.get(entitiesNextPage.size() - 1);
            long currentPageLastEntityPosition = lastImportedEntity.getPosition();
            long currentPageLastEntitySequence = Optional.ofNullable(lastImportedEntity.getSequence()).orElse(0L);
            OffsetDateTime startTime = LocalDateUtil.getCurrentDateTime();
            this.importService.executeImport(entitiesNextPage, () -> {
                OffsetDateTime endTime = LocalDateUtil.getCurrentDateTime();
                long took = endTime.toInstant().toEpochMilli() - startTime.toInstant().toEpochMilli();
                Timer indexingDurationTimer = this.getIndexingDurationTimer();
                indexingDurationTimer.record(took, TimeUnit.MILLISECONDS);
                ((PositionBasedImportIndexHandler)this.importIndexHandler).updateLastPersistedEntityPositionAndSequence(currentPageLastEntityPosition, currentPageLastEntitySequence);
                ((PositionBasedImportIndexHandler)this.importIndexHandler).updateTimestampOfLastPersistedEntity(OffsetDateTime.ofInstant(Instant.ofEpochMilli(lastImportedEntity.getTimestamp()), ZoneId.systemDefault()));
                OptimizeMetrics.recordOverallEntitiesImportTime(entitiesNextPage);
                importCompleteCallback.run();
            });
            ((PositionBasedImportIndexHandler)this.importIndexHandler).updatePendingLastEntityPositionAndSequence(currentPageLastEntityPosition, currentPageLastEntitySequence);
        } else {
            importCompleteCallback.run();
        }
        return entitiesNextPage.size() >= this.configurationService.getConfiguredZeebe().getMaxImportPageSize();
    }

    public Timer getIndexingDurationTimer() {
        return OptimizeMetrics.getTimer(MetricEnum.INDEXING_DURATION_METRIC, this.getRecordType(), this.getPartitionId());
    }

    protected abstract String getRecordType();

    protected abstract Integer getPartitionId();

    private void calculateNewDateUntilIsBlocked() {
        if (this.idleBackoffCalculator.isMaximumBackoffReached()) {
            this.logger.debug("Maximum idle backoff reached, this mediator will not backoff any further than {}ms.", (Object)this.idleBackoffCalculator.getMaximumBackoffMilliseconds());
        }
        long sleepTime = this.idleBackoffCalculator.calculateSleepTime();
        this.logger.debug("Was not able to produce a new job, sleeping for [{}] ms", (Object)sleepTime);
    }

    private void sleep(long timeToSleep) {
        try {
            Thread.sleep(timeToSleep);
        }
        catch (InterruptedException e) {
            this.logger.error("Was interrupted from sleep.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

