/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities;

import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.service.entities.dashboard.DashboardExportService;
import io.camunda.optimize.service.entities.report.ReportExportService;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityExportService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityExportService.class);
    private final ReportExportService reportExportService;
    private final DashboardExportService dashboardExportService;

    public EntityExportService(ReportExportService reportExportService, DashboardExportService dashboardExportService) {
        this.reportExportService = reportExportService;
        this.dashboardExportService = dashboardExportService;
    }

    public List<ReportDefinitionExportDto> getReportExportDtos(Set<String> reportIds) {
        return this.reportExportService.getReportExportDtos(reportIds);
    }

    public List<ReportDefinitionExportDto> getReportExportDtosAsUser(String userId, Set<String> reportIds) {
        return this.reportExportService.getReportExportDtosAsUser(userId, reportIds);
    }

    public List<OptimizeEntityExportDto> getDashboardExportDtos(Set<String> dashboardIds) {
        return this.dashboardExportService.getCompleteDashboardExport(dashboardIds);
    }

    public List<OptimizeEntityExportDto> getCompleteDashboardExportAsUser(String userId, String dashboardId) {
        return this.dashboardExportService.getCompleteDashboardExport(userId, dashboardId);
    }
}

