/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.digest;

import co.elastic.clients.util.Pair;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.processoverview.KpiResultDto;
import io.camunda.optimize.dto.optimize.query.processoverview.KpiType;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestRequestDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.target_value.TargetValueUnit;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.KpiService;
import io.camunda.optimize.service.db.reader.ProcessOverviewReader;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.writer.ProcessOverviewWriter;
import io.camunda.optimize.service.digest.DigestTask;
import io.camunda.optimize.service.email.EmailService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.util.DurationFormatterUtil;
import io.camunda.optimize.service.util.RootUrlGenerator;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class DigestService
implements ConfigurationReloadable {
    private static final String DIGEST_EMAIL_TEMPLATE = "digestEmailTemplate.ftl";
    private static final String UTM_SOURCE = "digest";
    private static final String UTM_MEDIUM = "email";
    private static final String DEFAULT_LOCALE = "en";
    private static final Logger LOG = LoggerFactory.getLogger(DigestService.class);
    private final ConfigurationService configurationService;
    private final EmailService emailService;
    private final AbstractIdentityService identityService;
    private final KpiService kpiService;
    private final DefinitionService definitionService;
    private final ProcessOverviewWriter processOverviewWriter;
    private final ProcessOverviewReader processOverviewReader;
    private final ReportReader reportReader;
    private final RootUrlGenerator rootUrlGenerator;
    private final Map<String, ScheduledFuture<?>> scheduledDigestTasks = new HashMap();
    private ThreadPoolTaskScheduler digestTaskScheduler;

    public DigestService(ConfigurationService configurationService, EmailService emailService, AbstractIdentityService identityService, KpiService kpiService, DefinitionService definitionService, ProcessOverviewWriter processOverviewWriter, ProcessOverviewReader processOverviewReader, ReportReader reportReader, RootUrlGenerator rootUrlGenerator) {
        this.configurationService = configurationService;
        this.emailService = emailService;
        this.identityService = identityService;
        this.kpiService = kpiService;
        this.definitionService = definitionService;
        this.processOverviewWriter = processOverviewWriter;
        this.processOverviewReader = processOverviewReader;
        this.reportReader = reportReader;
        this.rootUrlGenerator = rootUrlGenerator;
    }

    @PostConstruct
    public void init() {
        this.initTaskScheduler();
        this.initExistingDigests();
    }

    @PreDestroy
    public void destroy() {
        if (this.digestTaskScheduler != null) {
            this.digestTaskScheduler.destroy();
            this.digestTaskScheduler = null;
        }
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.destroy();
        this.init();
    }

    public void handleDigestTask(String processDefinitionKey) {
        LOG.debug("Checking for active digests on process [{}].", (Object)processDefinitionKey);
        ProcessOverviewDto overviewDto = this.processOverviewReader.getProcessOverviewByKey(processDefinitionKey).orElseThrow(() -> {
            this.unscheduleDigest(processDefinitionKey);
            return new OptimizeRuntimeException("Overview for process [" + processDefinitionKey + "] no longer exists. Unscheduling respective digest.");
        });
        if (overviewDto.getDigest().isEnabled()) {
            LOG.info("Creating KPI digest for process [{}].", (Object)processDefinitionKey);
            this.sendDigestAndUpdateLatestKpiResults(overviewDto);
        } else {
            LOG.info("Digest on process [{}] is disabled.", (Object)processDefinitionKey);
        }
    }

    public void handleProcessUpdate(String processDefKey, ProcessUpdateDto processUpdateDto) {
        if (processUpdateDto.getProcessDigest().isEnabled()) {
            this.rescheduleDigest(processDefKey, processUpdateDto.getProcessDigest());
        } else {
            this.unscheduleDigest(processDefKey);
        }
    }

    private void rescheduleDigest(String processDefKey, ProcessDigestRequestDto digestRequestDto) {
        this.unscheduleDigest(processDefKey);
        this.scheduleDigest(processDefKey);
        if (digestRequestDto.isEnabled()) {
            this.handleDigestTask(processDefKey);
        }
    }

    private void initTaskScheduler() {
        if (this.digestTaskScheduler == null) {
            this.digestTaskScheduler = new ThreadPoolTaskScheduler();
            this.digestTaskScheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.digestTaskScheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.digestTaskScheduler.setThreadNamePrefix("DigestTaskScheduler");
            this.digestTaskScheduler.initialize();
        }
    }

    private void initExistingDigests() {
        LOG.debug("Scheduling digest tasks for all existing enabled process digests.");
        this.processOverviewReader.getAllActiveProcessDigestsByKey().forEach((processDefinitionKey, digest) -> this.scheduleDigest((String)processDefinitionKey));
    }

    private void scheduleDigest(String processDefinitionKey) {
        this.scheduledDigestTasks.put(processDefinitionKey, this.digestTaskScheduler.schedule((Runnable)this.createDigestTask(processDefinitionKey), (Trigger)new CronTrigger(this.configurationService.getDigestCronTrigger())));
    }

    private void unscheduleDigest(String processDefinitionKey) {
        Optional.ofNullable(this.scheduledDigestTasks.remove(processDefinitionKey)).ifPresent(task -> task.cancel(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDigestAndUpdateLatestKpiResults(ProcessOverviewDto overviewDto) {
        List<KpiResultDto> mostRecentKpiReportResults = this.kpiService.extractMostRecentKpiResultsForCurrentKpiReportsForProcess(overviewDto, DEFAULT_LOCALE);
        try {
            this.composeAndSendDigestEmail(overviewDto, mostRecentKpiReportResults);
        }
        catch (Exception e) {
            LOG.error("Failed to send digest email", (Throwable)e);
        }
        finally {
            this.updateBaselineKpiReportResults(overviewDto.getProcessDefinitionKey(), mostRecentKpiReportResults);
        }
    }

    private void composeAndSendDigestEmail(ProcessOverviewDto overviewDto, List<KpiResultDto> currentKpiReportResults) {
        Optional<UserDto> processOwner = this.identityService.getUserById(overviewDto.getOwner());
        String definitionName = this.definitionService.getLatestCachedDefinitionOnAnyTenant(DefinitionType.PROCESS, overviewDto.getProcessDefinitionKey()).map(DefinitionOptimizeResponseDto::getName).orElse(overviewDto.getProcessDefinitionKey());
        this.emailService.sendTemplatedEmailWithErrorHandling(processOwner.map(UserDto::getEmail).orElse(null), String.format("[%s - Optimize] Process Digest for Process \"%s\"", this.configurationService.getNotificationEmailCompanyBranding(), definitionName), DIGEST_EMAIL_TEMPLATE, this.createInputsForTemplate(processOwner.map(IdentityWithMetadataResponseDto::getName).orElse(overviewDto.getOwner()), definitionName, currentKpiReportResults, overviewDto.getDigest().getKpiReportResults()));
    }

    private Map<String, Object> createInputsForTemplate(String ownerName, String processDefinitionName, List<KpiResultDto> currentKpiReportResults, Map<String, String> previousKpiReportResults) {
        return Map.of("ownerName", ownerName, "processName", processDefinitionName, "hasTimeKpis", currentKpiReportResults.stream().anyMatch(kpiResult -> KpiType.TIME.equals((Object)kpiResult.getType())), "hasQualityKpis", currentKpiReportResults.stream().anyMatch(kpiResult -> KpiType.QUALITY.equals((Object)kpiResult.getType())), "successfulTimeKPIPercent", this.calculateSuccessfulKpiInPercent(KpiType.TIME, currentKpiReportResults), "successfulQualityKPIPercent", this.calculateSuccessfulKpiInPercent(KpiType.QUALITY, currentKpiReportResults), "kpiResults", this.getKpiSummaryDtos(processDefinitionName, currentKpiReportResults, previousKpiReportResults), "optimizeHomePageLink", this.getOptimizeHomePageLink());
    }

    private int calculateSuccessfulKpiInPercent(KpiType kpiType, List<KpiResultDto> kpiResults) {
        long resultCount = kpiResults.stream().filter(kpiResult -> kpiType.equals((Object)kpiResult.getType())).count();
        long successfulResultCount = kpiResults.stream().filter(kpiResult -> kpiType.equals((Object)kpiResult.getType())).filter(KpiResultDto::isTargetMet).count();
        return resultCount == 0L ? 0 : (int)(100.0 * (double)successfulResultCount / (double)resultCount);
    }

    private void updateBaselineKpiReportResults(String processDefinitionKey, List<KpiResultDto> mostRecentKpiReportResults) {
        HashMap reportIdsToValues = new HashMap();
        mostRecentKpiReportResults.forEach(result -> reportIdsToValues.put(result.getReportId(), result.getValue()));
        this.processOverviewWriter.updateProcessDigestResults(processDefinitionKey, new ProcessDigestDto(reportIdsToValues));
    }

    private DigestTask createDigestTask(String processDefinitionKey) {
        return new DigestTask(this, processDefinitionKey);
    }

    private String getOptimizeHomePageLink() {
        return this.rootUrlGenerator.getRootUrl() + "/#/";
    }

    private String getReportViewLink(String reportId, String collectionId) {
        return this.rootUrlGenerator.getRootUrl() + this.getReportViewLinkPath(reportId, collectionId);
    }

    private String getReportViewLinkPath(String reportId, String collectionId) {
        return Optional.ofNullable(collectionId).map(colId -> String.format("/#/collection/%s/report/%s?utm_medium=%s&utm_source=%s", colId, reportId, UTM_MEDIUM, UTM_SOURCE)).orElse(String.format("/#/report/%s?utm_medium=%s&utm_source=%s", reportId, UTM_MEDIUM, UTM_SOURCE));
    }

    private List<DigestTemplateKpiSummaryDto> getKpiSummaryDtos(String processDefinitionName, List<KpiResultDto> currentKpiReportResults, Map<String, String> previousKpiReportResults) {
        return currentKpiReportResults.stream().map(kpiResult -> {
            Optional<ReportDefinitionDto> reportDefinition = this.reportReader.getReport(kpiResult.getReportId());
            if (reportDefinition.isEmpty()) {
                LOG.error("Report [{}] could not be retrieved for creation of digest email for process [{}] because report no longer exists. This report will be excluded from the digest.", (Object)kpiResult.getReportId(), (Object)processDefinitionName);
            }
            return Pair.of(reportDefinition, (Object)kpiResult);
        }).filter(kpiReportResultTuple -> ((Optional)kpiReportResultTuple.key()).isPresent()).map(kpiReportResultTuple -> new DigestTemplateKpiSummaryDto(((ReportDefinitionDto)((Optional)kpiReportResultTuple.key()).get()).getName(), this.getReportViewLink(((KpiResultDto)kpiReportResultTuple.value()).getReportId(), ((ReportDefinitionDto)((Optional)kpiReportResultTuple.key()).get()).getCollectionId()), (KpiResultDto)kpiReportResultTuple.value(), (String)Optional.ofNullable(previousKpiReportResults).orElse(Collections.emptyMap()).get(((KpiResultDto)kpiReportResultTuple.value()).getReportId()))).toList();
    }

    private static double calculatePercentageChange(KpiResultDto kpiResult, double previousValueAsDouble) {
        try {
            return 100.0 * ((Double.parseDouble(kpiResult.getValue()) - previousValueAsDouble) / previousValueAsDouble);
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Value could not be parsed to number: " + kpiResult.getValue());
        }
    }

    public static class DigestTemplateKpiSummaryDto {
        private final String reportName;
        private final String reportLink;
        private final String kpiType;
        private final boolean targetMet;
        private final String target;
        private final String current;
        private final Double changeInPercent;
        private final KpiChangeType changeType;

        public DigestTemplateKpiSummaryDto(String reportName, String reportLink, KpiResultDto kpiResultDto, @Nullable String previousValue) {
            this.reportName = reportName;
            this.reportLink = reportLink;
            this.kpiType = StringUtils.capitalize((String)kpiResultDto.getType().getId());
            this.targetMet = kpiResultDto.isTargetMet();
            this.target = this.getKpiTargetString(kpiResultDto.getTarget(), kpiResultDto.getUnit(), kpiResultDto.getMeasure(), kpiResultDto.isBelow());
            this.current = this.getKpiValueString(kpiResultDto.getValue(), kpiResultDto.getMeasure());
            this.changeInPercent = this.getKpiChangeInPercent(kpiResultDto, previousValue);
            this.changeType = this.evaluateChangeType(kpiResultDto, this.getKpiChangeInPercent(kpiResultDto, previousValue));
        }

        private String getKpiTargetString(String target, TargetValueUnit unit, ViewProperty kpiMeasure, boolean isBelow) {
            Object targetString;
            if (ViewProperty.DURATION.equals((Object)kpiMeasure)) {
                targetString = target + " " + StringUtils.capitalize((String)unit.getId());
            } else if (ViewProperty.PERCENTAGE.equals((Object)kpiMeasure)) {
                try {
                    targetString = String.format("%.2f %%", Double.parseDouble(target));
                }
                catch (NumberFormatException e) {
                    throw new OptimizeRuntimeException("Value could not be parsed to number: " + target, (Throwable)e);
                }
            } else {
                targetString = target;
            }
            return String.format("%s %s", isBelow ? "<" : ">", targetString);
        }

        private String getKpiValueString(String value, ViewProperty kpiMeasure) {
            if (Optional.ofNullable(value).isEmpty()) {
                return "NA";
            }
            if (ViewProperty.DURATION.equals((Object)kpiMeasure)) {
                try {
                    return DurationFormatterUtil.formatMilliSecondsToReadableDurationString((long)Double.parseDouble(value));
                }
                catch (NumberFormatException e) {
                    throw new OptimizeRuntimeException("Value could not be parsed to number: " + value, (Throwable)e);
                }
            }
            if (ViewProperty.PERCENTAGE.equals((Object)kpiMeasure)) {
                try {
                    return String.format("%.2f %%", Double.parseDouble(value));
                }
                catch (NumberFormatException e) {
                    throw new OptimizeRuntimeException("Value could not be parsed to number: " + value, (Throwable)e);
                }
            }
            return value;
        }

        private Double getKpiChangeInPercent(KpiResultDto kpiResult, @Nullable String previousValue) {
            double previousValueAsDouble;
            try {
                previousValueAsDouble = previousValue == null ? Double.NaN : Double.parseDouble(previousValue);
            }
            catch (NumberFormatException e) {
                throw new OptimizeRuntimeException("Unable to correctly parse previousValue in kpi result: " + previousValue);
            }
            return previousValue == null || previousValueAsDouble == 0.0 ? 0.0 : DigestService.calculatePercentageChange(kpiResult, previousValueAsDouble);
        }

        private KpiChangeType evaluateChangeType(KpiResultDto kpiResultDto, Double changeInPercent) {
            if (changeInPercent == 0.0) {
                return KpiChangeType.NEUTRAL;
            }
            if (kpiResultDto.isBelow()) {
                return changeInPercent < 0.0 ? KpiChangeType.GOOD : KpiChangeType.BAD;
            }
            return changeInPercent > 0.0 ? KpiChangeType.GOOD : KpiChangeType.BAD;
        }

        public String getReportName() {
            return this.reportName;
        }

        public String getReportLink() {
            return this.reportLink;
        }

        public String getKpiType() {
            return this.kpiType;
        }

        public boolean isTargetMet() {
            return this.targetMet;
        }

        public String getTarget() {
            return this.target;
        }

        public String getCurrent() {
            return this.current;
        }

        public Double getChangeInPercent() {
            return this.changeInPercent;
        }

        public KpiChangeType getChangeType() {
            return this.changeType;
        }

        protected boolean canEqual(Object other) {
            return other instanceof DigestTemplateKpiSummaryDto;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "DigestService.DigestTemplateKpiSummaryDto(reportName=" + this.getReportName() + ", reportLink=" + this.getReportLink() + ", kpiType=" + this.getKpiType() + ", targetMet=" + this.isTargetMet() + ", target=" + this.getTarget() + ", current=" + this.getCurrent() + ", changeInPercent=" + this.getChangeInPercent() + ", changeType=" + String.valueOf((Object)this.getChangeType()) + ")";
        }
    }

    public static enum KpiChangeType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

