/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.dto.optimize.query.TerminatedUserSessionDto;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.io.IOException;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TerminatedUserSessionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TerminatedUserSessionWriter.class);

    public void writeTerminatedUserSession(TerminatedUserSessionDto sessionDto) {
        LOG.debug("Writing terminated user session with id [{}] to database.", (Object)sessionDto.getId());
        try {
            this.performWritingTerminatedUserSession(sessionDto);
        }
        catch (IOException e) {
            String message = "Could not write terminated user sessions to database.";
            LOG.error("Could not write terminated user sessions to database.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not write terminated user sessions to database.", (Throwable)e);
        }
    }

    public void deleteTerminatedUserSessionsOlderThan(OffsetDateTime timestamp) {
        LOG.debug("Deleting terminated user session older than [{}] to database.", (Object)timestamp);
        try {
            this.performDeleteTerminatedUserSessionOlderThan(timestamp);
        }
        catch (IOException e) {
            String message = String.format("Could not delete user sessions older than [%s] from database", timestamp);
            LOG.error(message, (Throwable)e);
            throw new OptimizeRuntimeException(message, (Throwable)e);
        }
    }

    protected abstract void performWritingTerminatedUserSession(TerminatedUserSessionDto var1) throws IOException;

    protected abstract void performDeleteTerminatedUserSessionOlderThan(OffsetDateTime var1) throws IOException;
}

