/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.schema.ScriptData;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class DatabaseWriterUtil {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private DatabaseWriterUtil() {
    }

    public static <T> Map<String, T> createFieldUpdateScriptParams(Set<String> fields, Object entityDto, ObjectMapper objectMapper) {
        Map entityAsMap = (Map)objectMapper.convertValue(entityDto, (TypeReference)new TypeReference<Map<String, Object>>(){});
        HashMap params = new HashMap();
        for (String fieldName : fields) {
            Object fieldValue = entityAsMap.get(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue instanceof TemporalAccessor) {
                TemporalAccessor temporalAccessor = (TemporalAccessor)fieldValue;
                fieldValue = DATE_TIME_FORMATTER.format(temporalAccessor);
            }
            params.put(fieldName, fieldValue);
        }
        return params;
    }

    public static String createUpdateFieldsScript(Set<String> fieldKeys) {
        return fieldKeys.stream().map(fieldKey -> String.format("%s.%s = params.%s;%n", "ctx._source", fieldKey, fieldKey)).collect(Collectors.joining());
    }

    public static ScriptData createScriptData(String stringScript, Map<String, Object> params, ObjectMapper objectMapper) {
        return new ScriptData(DatabaseWriterUtil.mapParamsForScriptCreation(params, objectMapper), stringScript);
    }

    public static ScriptData createScriptData(Set<String> fields, Object entityDto, ObjectMapper objectMapper) {
        Map params = DatabaseWriterUtil.createFieldUpdateScriptParams(fields, entityDto, objectMapper);
        return new ScriptData(DatabaseWriterUtil.mapParamsForScriptCreation(params, objectMapper), DatabaseWriterUtil.createUpdateFieldsScript(params.keySet()));
    }

    public static <T> Map<String, T> mapParamsForScriptCreation(Map<String, T> parameters, ObjectMapper objectMapper) {
        return Optional.ofNullable(parameters).map(value -> (Map)objectMapper.convertValue(value, new TypeReference<Map<String, T>>(){})).orElse(Collections.emptyMap());
    }
}

