/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.service.db.repository.MappingMetadataRepository;
import io.camunda.optimize.service.db.repository.SnapshotRepository;
import io.camunda.optimize.service.util.SnapshotUtil;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BackupWriter.class);
    private final MappingMetadataRepository mappingMetadataRepository;
    private final SnapshotRepository snapshotRepository;

    public BackupWriter(MappingMetadataRepository mappingMetadataRepository, SnapshotRepository snapshotRepository) {
        this.mappingMetadataRepository = mappingMetadataRepository;
        this.snapshotRepository = snapshotRepository;
    }

    public void triggerSnapshotCreation(Long backupId) {
        String snapshot1Name = SnapshotUtil.getSnapshotNameForImportIndices(backupId);
        String snapshot2Name = SnapshotUtil.getSnapshotNameForNonImportIndices(backupId);
        CompletableFuture.runAsync(() -> {
            this.snapshotRepository.triggerSnapshot(snapshot1Name, this.getIndexAliasesWithImportIndexFlag(true));
            this.snapshotRepository.triggerSnapshot(snapshot2Name, this.getIndexAliasesWithImportIndexFlag(false));
        });
    }

    public void deleteOptimizeSnapshots(Long backupId) {
        this.snapshotRepository.deleteOptimizeSnapshots(backupId);
    }

    private String[] getIndexAliasesWithImportIndexFlag(boolean isImportIndex) {
        return this.mappingMetadataRepository.getIndexAliasesWithImportIndexFlag(isImportIndex);
    }
}

