/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.util;

import java.util.Arrays;
import java.util.stream.Collectors;

public final class AggregationNameUtil {
    private static final String[] ILLEGAL_CHARS = new String[]{"[", "]", ">"};
    private static final String ILLEGAL_CHAR_REGEX = Arrays.stream(ILLEGAL_CHARS).map(illegalChar -> "\\" + illegalChar).collect(Collectors.joining("|"));

    private AggregationNameUtil() {
    }

    public static boolean containsIllegalChar(String aggregationName) {
        return Arrays.stream(ILLEGAL_CHARS).anyMatch(aggregationName::contains);
    }

    public static String sanitiseAggName(String aggregationName) {
        return aggregationName.replaceAll(ILLEGAL_CHAR_REGEX, "_");
    }
}

