/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.os;

import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.repository.ProcessRepository;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessRepositoryOS
implements ProcessRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final OptimizeIndexNameService indexNameService;

    public ProcessRepositoryOS(OptimizeOpenSearchClient osClient, OptimizeIndexNameService indexNameService) {
        this.osClient = osClient;
        this.indexNameService = indexNameService;
    }

    @Override
    public Map<String, ProcessOverviewDto> getProcessOverviewsByKey(Set<String> processDefinitionKeys) {
        LOG.debug("Fetching process overviews for [{}] processes", (Object)processDefinitionKeys.size());
        if (processDefinitionKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview"), new String[0]).query(QueryDSL.ids(processDefinitionKeys)).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, ProcessOverviewDto.class).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, Function.identity()));
    }

    @Override
    public Map<String, ProcessDigestResponseDto> getAllActiveProcessDigestsByKey() {
        LOG.debug("Fetching all available process overviews.");
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview"), new String[0]).query(QueryDSL.term((String)"digest.enabled", (boolean)true)).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, ProcessOverviewDto.class).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, ProcessOverviewDto::getDigest));
    }

    @Override
    public Map<String, ProcessOverviewDto> getProcessOverviewsWithPendingOwnershipData() {
        LOG.debug("Fetching pending process overviews");
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("process-overview"), new String[0]).query(QueryDSL.prefix((String)"processDefinitionKey", (String)"pendingauthcheck")).size(Integer.valueOf(1000));
        return this.osClient.searchValues(requestBuilder, ProcessOverviewDto.class).stream().collect(Collectors.toMap(ProcessOverviewDto::getProcessDefinitionKey, Function.identity()));
    }
}

