/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.repository.SnapshotRepository;
import io.camunda.optimize.service.util.SnapshotUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotResponse;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class SnapshotRepositoryOS
implements SnapshotRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotRepositoryOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public SnapshotRepositoryOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public void deleteOptimizeSnapshots(Long backupId) {
        this.osClient.getRichOpenSearchClient().async().snapshot().delete(this.configurationService.getOpenSearchConfiguration().getSnapshotRepositoryName(), SnapshotUtil.getSnapshotPrefixWithBackupId(backupId) + "*", e -> "Failed to send delete snapshot request to Opensearch!").whenComplete((deleteSnapshotResponse, throwable) -> {
            if (throwable != null) {
                this.onSnapshotDeletionFailed((Throwable)throwable, backupId);
            } else if (deleteSnapshotResponse != null) {
                this.onSnapshotDeleted((DeleteSnapshotResponse)deleteSnapshotResponse, backupId);
            }
        });
    }

    @Override
    public void triggerSnapshot(String snapshotName, String[] indexNames) {
        LOG.info("Triggering async snapshot {}.", (Object)snapshotName);
        this.osClient.getRichOpenSearchClient().async().snapshot().create(this.configurationService.getOpenSearchConfiguration().getSnapshotRepositoryName(), snapshotName, Arrays.asList(indexNames), e -> String.format("Failed to send create snapshot %s request to Opensearch!", snapshotName)).whenComplete((createSnapshotResponse, throwable) -> {
            if (createSnapshotResponse != null) {
                this.onSnapshotCreated((CreateSnapshotResponse)createSnapshotResponse);
            }
            if (throwable != null) {
                this.onSnapshotCreationFailed((Throwable)throwable, snapshotName);
            }
        });
    }

    private void onSnapshotDeletionFailed(Throwable e, Long backupId) {
        if (e instanceof IOException) {
            String reason = String.format("Encountered an error connecting to Opensearch while attempting to delete snapshots for backupID [%s].", backupId);
            LOG.error(reason, e);
        } else {
            String reason = String.format("Failed to delete snapshots for backupID [%s]", backupId);
            LOG.error(reason, e);
        }
    }

    private void onSnapshotDeleted(DeleteSnapshotResponse deleteSnapshotResponse, Long backupId) {
        if (deleteSnapshotResponse.acknowledged()) {
            String reason = String.format("Request to delete all Optimize snapshots with the backupID [%d] successfully submitted", backupId);
            LOG.info(reason);
        } else {
            String reason = String.format("Request to delete all Optimize snapshots with the backupID [%d] was not acknowledged by Opencsearch.", backupId);
            LOG.error(reason);
        }
    }

    private void onSnapshotCreationFailed(Throwable e, String snapshotName) {
        if (e instanceof IOException) {
            String reason = String.format("Encountered an error connecting to OpenSearch while attempting to create snapshot [%s].", snapshotName);
            LOG.error(reason, e);
        } else {
            String reason = String.format("Failed to take snapshot [%s]", snapshotName);
            LOG.error(reason, e);
        }
    }

    private void onSnapshotCreated(CreateSnapshotResponse createSnapshotResponse) {
        SnapshotInfo snapshotInfo = createSnapshotResponse.snapshot();
        switch (snapshotInfo.state()) {
            case "SUCCESS": {
                LOG.info("Successfully taken snapshot [{}].", (Object)snapshotInfo.snapshot());
                break;
            }
            case "FAILED": {
                String reason = String.format("Snapshot execution failed for [%s], reason: %s", snapshotInfo.snapshot(), snapshotInfo.reason());
                LOG.error(reason);
                break;
            }
            default: {
                String reason = String.format("Snapshot status [%s] for snapshot with ID [%s]", snapshotInfo.state(), snapshotInfo.snapshot());
                LOG.warn(reason);
            }
        }
    }
}

