/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.LabelDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableSourceDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValuesQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.query.variable.VariableUpdateInstanceDto;
import io.camunda.optimize.service.db.schema.ScriptData;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface VariableRepository {
    public static final String FILTERED_VARIABLES_AGGREGATION = "filteredVariables";
    public static final String VALUE_AGGREGATION = "values";
    public static final String VARIABLE_VALUE_NGRAM = "nGramField";
    public static final String VARIABLE_VALUE_LOWERCASE = "lowercaseField";
    public static final String NAME_AGGREGATION = "variableNameAggregation";
    public static final String TYPE_AGGREGATION = "variableTypeAggregation";
    public static final String VAR_NAME_AND_TYPE_COMPOSITE_AGG = "varNameAndTypeCompositeAgg";
    public static final String INDEX_AGGREGATION = "_index";
    public static final String PROCESS_INSTANCE_INDEX_NAME_SUBSECTION = "-process-instance-";

    public void deleteVariableDataByProcessInstanceIds(String var1, List<String> var2);

    public void upsertVariableLabel(String var1, DefinitionVariableLabelsDto var2, ScriptData var3);

    public void deleteVariablesForDefinition(String var1, String var2);

    public void deleteByProcessInstanceIds(List<String> var1);

    public Map<String, DefinitionVariableLabelsDto> getVariableLabelsByKey(List<String> var1);

    public List<VariableUpdateInstanceDto> getVariableInstanceUpdatesForProcessInstanceIds(Set<String> var1);

    public void writeExternalProcessVariables(List<ExternalProcessVariableDto> var1, String var2);

    public void deleteExternalVariablesIngestedBefore(OffsetDateTime var1, String var2);

    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAfter(Long var1, int var2);

    public List<ExternalProcessVariableDto> getVariableUpdatesIngestedAt(Long var1);

    public List<String> getDecisionVariableValues(DecisionVariableValueRequestDto var1, String var2);

    public List<ProcessVariableNameResponseDto> getVariableNames(ProcessVariableNameRequestDto var1, List<ProcessToQueryDto> var2, List<String> var3, Map<String, DefinitionVariableLabelsDto> var4);

    public List<ProcessVariableNameResponseDto> getVariableNamesForInstancesMatchingQuery(List<String> var1, Supplier<BoolQuery.Builder> var2, Map<String, DefinitionVariableLabelsDto> var3);

    public List<String> getVariableValues(ProcessVariableValuesQueryDto var1, List<ProcessVariableSourceDto> var2);

    default public String getValueSearchField(String variablePath, String searchFieldName) {
        return DecisionVariableHelper.getVariableValueField(variablePath) + "." + searchFieldName;
    }

    default public String buildWildcardQuery(String valueFilter) {
        return "*" + valueFilter + "*";
    }

    default public String extractProcessDefinitionKeyFromIndexName(String indexName) {
        int lastIndex;
        int firstIndex = indexName.indexOf(PROCESS_INSTANCE_INDEX_NAME_SUBSECTION);
        if (firstIndex != (lastIndex = indexName.lastIndexOf(PROCESS_INSTANCE_INDEX_NAME_SUBSECTION))) {
            return null;
        }
        int processDefKeyStartIndex = firstIndex + PROCESS_INSTANCE_INDEX_NAME_SUBSECTION.length();
        int processDefKeyEndIndex = indexName.lastIndexOf("_v8");
        return indexName.substring(processDefKeyStartIndex, processDefKeyEndIndex);
    }

    default public ProcessVariableNameResponseDto processVariableNameResponseDtoFrom(Map<String, DefinitionVariableLabelsDto> definitionLabelsByKey, String processDefinitionKey, String variableName, String variableType) {
        String labelValue = null;
        if (processDefinitionKey != null && definitionLabelsByKey.containsKey(processDefinitionKey)) {
            List labels = definitionLabelsByKey.get(processDefinitionKey).getLabels();
            for (LabelDto label : labels) {
                if (!label.getVariableName().equals(variableName) || !label.getVariableType().toString().equalsIgnoreCase(variableType)) continue;
                labelValue = label.getVariableLabel();
            }
        }
        return new ProcessVariableNameResponseDto(variableName, VariableType.getTypeForId((String)variableType), labelValue);
    }

    default public List<ProcessVariableNameResponseDto> filterVariableNameResults(List<ProcessVariableNameResponseDto> variableNames) {
        return variableNames.stream().distinct().filter(varName -> !VariableType.OBJECT.equals((Object)varName.getType())).collect(Collectors.toList());
    }
}

