/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.service;

import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.util.AggregateByDateUnitMapper;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;

public class DateAggregationService {
    public static Duration getDateHistogramIntervalDurationFromMinMax(MinMaxStatDto minMaxStats) {
        long intervalFromMinToMax = (long)(minMaxStats.getMax() - minMaxStats.getMin()) / 80L;
        return Duration.of(Math.max(intervalFromMinToMax, 1L), ChronoUnit.MILLIS);
    }

    protected ZonedDateTime getEndOfBucket(ZonedDateTime startOfBucket, AggregateByDateUnit unit, Duration durationOfAutomaticInterval) {
        return AggregateByDateUnit.AUTOMATIC.equals((Object)unit) ? startOfBucket.plus(durationOfAutomaticInterval) : startOfBucket.plus(1L, AggregateByDateUnitMapper.mapToChronoUnit((AggregateByDateUnit)unit));
    }

    protected ZonedDateTime truncateToUnit(ZonedDateTime dateToTruncate, AggregateByDateUnit unit) {
        switch (unit) {
            case YEAR: {
                return dateToTruncate.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
            }
            case MONTH: {
                return dateToTruncate.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEK: {
                return dateToTruncate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
            }
            case DAY: 
            case HOUR: 
            case MINUTE: {
                return dateToTruncate.truncatedTo(AggregateByDateUnitMapper.mapToChronoUnit((AggregateByDateUnit)unit));
            }
            case AUTOMATIC: {
                return dateToTruncate;
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + String.valueOf(unit));
    }
}

