/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.result;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.ReportResultType;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;

public class ResultInterpreter {
    public static CommandEvaluationResult interpret(ExecutionContext executionContext, CompositeCommandResult result) {
        return switch (ResultInterpreter.getReportResultType(executionContext)) {
            default -> throw new MatchException(null, null);
            case ReportResultType.HYPER_MAP -> result.transformToHyperMap();
            case ReportResultType.MAP -> result.transformToMap();
            case ReportResultType.NUMBER -> result.transformToNumber();
            case ReportResultType.RAW_DATA -> result.transformToRawData();
        };
    }

    private static ReportResultType getReportResultType(ExecutionContext executionContext) {
        Object p = executionContext.getPlan();
        if (p instanceof DecisionExecutionPlan) {
            DecisionExecutionPlan decisionExecutionPlan = (DecisionExecutionPlan)p;
            return decisionExecutionPlan.getResultType();
        }
        p = executionContext.getPlan();
        if (p instanceof ProcessExecutionPlan) {
            ProcessExecutionPlan processExecutionPlan = (ProcessExecutionPlan)p;
            return processExecutionPlan.getResultType();
        }
        throw new OptimizeRuntimeException("Unable to extract report result type from " + String.valueOf(executionContext.getPlan()));
    }
}

