/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.context;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.custom_buckets.CustomBucketDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class VariableAggregationContext {
    private final String variableName;
    private final VariableType variableType;
    private final String variablePath;
    private final String nestedVariableNameField;
    private final String nestedVariableValueFieldLabel;
    private final ZoneId timezone;
    private final CustomBucketDto customBucketDto;
    private final AggregateByDateUnit dateUnit;
    private final String[] indexNames;
    private MinMaxStatDto variableRangeMinMaxStats;
    private final MinMaxStatDto combinedRangeMinMaxStats;
    private final FilterContext filterContext;

    protected VariableAggregationContext(VariableAggregationContextBuilder<?, ?> b) {
        this.variableName = b.variableName;
        this.variableType = b.variableType;
        this.variablePath = b.variablePath;
        this.nestedVariableNameField = b.nestedVariableNameField;
        this.nestedVariableValueFieldLabel = b.nestedVariableValueFieldLabel;
        this.timezone = b.timezone;
        this.customBucketDto = b.customBucketDto;
        this.dateUnit = b.dateUnit;
        this.indexNames = b.indexNames;
        this.variableRangeMinMaxStats = b.variableRangeMinMaxStats;
        this.combinedRangeMinMaxStats = b.combinedRangeMinMaxStats;
        this.filterContext = b.filterContext;
        if (this.filterContext == null) {
            throw new IllegalArgumentException("FilterContext cannot be null");
        }
    }

    public Optional<MinMaxStatDto> getCombinedRangeMinMaxStats() {
        return Optional.ofNullable(this.combinedRangeMinMaxStats);
    }

    public double getMaxVariableValue() {
        return this.getCombinedRangeMinMaxStats().orElse(this.variableRangeMinMaxStats).getMax();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    public String getVariablePath() {
        return this.variablePath;
    }

    public String getNestedVariableNameField() {
        return this.nestedVariableNameField;
    }

    public String getNestedVariableValueFieldLabel() {
        return this.nestedVariableValueFieldLabel;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public CustomBucketDto getCustomBucketDto() {
        return this.customBucketDto;
    }

    public AggregateByDateUnit getDateUnit() {
        return this.dateUnit;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }

    public MinMaxStatDto getVariableRangeMinMaxStats() {
        return this.variableRangeMinMaxStats;
    }

    public FilterContext getFilterContext() {
        return this.filterContext;
    }

    public void setVariableRangeMinMaxStats(MinMaxStatDto variableRangeMinMaxStats) {
        this.variableRangeMinMaxStats = variableRangeMinMaxStats;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableAggregationContext;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "VariableAggregationContext(variableName=" + this.getVariableName() + ", variableType=" + String.valueOf(this.getVariableType()) + ", variablePath=" + this.getVariablePath() + ", nestedVariableNameField=" + this.getNestedVariableNameField() + ", nestedVariableValueFieldLabel=" + this.getNestedVariableValueFieldLabel() + ", timezone=" + String.valueOf(this.getTimezone()) + ", customBucketDto=" + String.valueOf(this.getCustomBucketDto()) + ", dateUnit=" + String.valueOf(this.getDateUnit()) + ", indexNames=" + Arrays.deepToString(this.getIndexNames()) + ", variableRangeMinMaxStats=" + String.valueOf(this.getVariableRangeMinMaxStats()) + ", combinedRangeMinMaxStats=" + String.valueOf(this.getCombinedRangeMinMaxStats()) + ", filterContext=" + String.valueOf(this.getFilterContext()) + ")";
    }

    public static VariableAggregationContextBuilder<?, ?> builder() {
        return new VariableAggregationContextBuilderImpl();
    }

    public static abstract class VariableAggregationContextBuilder<C extends VariableAggregationContext, B extends VariableAggregationContextBuilder<C, B>> {
        private String variableName;
        private VariableType variableType;
        private String variablePath;
        private String nestedVariableNameField;
        private String nestedVariableValueFieldLabel;
        private ZoneId timezone;
        private CustomBucketDto customBucketDto;
        private AggregateByDateUnit dateUnit;
        private String[] indexNames;
        private MinMaxStatDto variableRangeMinMaxStats;
        private MinMaxStatDto combinedRangeMinMaxStats;
        private FilterContext filterContext;

        public B variableName(String variableName) {
            this.variableName = variableName;
            return this.self();
        }

        public B variableType(VariableType variableType) {
            this.variableType = variableType;
            return this.self();
        }

        public B variablePath(String variablePath) {
            this.variablePath = variablePath;
            return this.self();
        }

        public B nestedVariableNameField(String nestedVariableNameField) {
            this.nestedVariableNameField = nestedVariableNameField;
            return this.self();
        }

        public B nestedVariableValueFieldLabel(String nestedVariableValueFieldLabel) {
            this.nestedVariableValueFieldLabel = nestedVariableValueFieldLabel;
            return this.self();
        }

        public B timezone(ZoneId timezone) {
            this.timezone = timezone;
            return this.self();
        }

        public B customBucketDto(CustomBucketDto customBucketDto) {
            this.customBucketDto = customBucketDto;
            return this.self();
        }

        public B dateUnit(AggregateByDateUnit dateUnit) {
            this.dateUnit = dateUnit;
            return this.self();
        }

        public B indexNames(String[] indexNames) {
            this.indexNames = indexNames;
            return this.self();
        }

        public B variableRangeMinMaxStats(MinMaxStatDto variableRangeMinMaxStats) {
            this.variableRangeMinMaxStats = variableRangeMinMaxStats;
            return this.self();
        }

        public B combinedRangeMinMaxStats(MinMaxStatDto combinedRangeMinMaxStats) {
            this.combinedRangeMinMaxStats = combinedRangeMinMaxStats;
            return this.self();
        }

        public B filterContext(FilterContext filterContext) {
            if (filterContext == null) {
                throw new IllegalArgumentException("filterContext must not be null");
            }
            this.filterContext = filterContext;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "VariableAggregationContext.VariableAggregationContextBuilder(variableName=" + this.variableName + ", variableType=" + String.valueOf(this.variableType) + ", variablePath=" + this.variablePath + ", nestedVariableNameField=" + this.nestedVariableNameField + ", nestedVariableValueFieldLabel=" + this.nestedVariableValueFieldLabel + ", timezone=" + String.valueOf(this.timezone) + ", customBucketDto=" + String.valueOf(this.customBucketDto) + ", dateUnit=" + String.valueOf(this.dateUnit) + ", indexNames=" + Arrays.deepToString(this.indexNames) + ", variableRangeMinMaxStats=" + String.valueOf(this.variableRangeMinMaxStats) + ", combinedRangeMinMaxStats=" + String.valueOf(this.combinedRangeMinMaxStats) + ", filterContext=" + String.valueOf(this.filterContext) + ")";
        }
    }

    private static final class VariableAggregationContextBuilderImpl
    extends VariableAggregationContextBuilder<VariableAggregationContext, VariableAggregationContextBuilderImpl> {
        private VariableAggregationContextBuilderImpl() {
        }

        @Override
        protected VariableAggregationContextBuilderImpl self() {
            return this;
        }

        @Override
        public VariableAggregationContext build() {
            return new VariableAggregationContext(this);
        }
    }
}

