/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import java.time.ZoneId;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ReportEvaluationContext<R extends ReportDefinitionDto<?>> {
    private R reportDefinition;
    private PaginationDto pagination;
    private boolean isCsvExport;
    private boolean isJsonExport;
    private Set<String> hiddenFlowNodeIds;
    private MinMaxStatDto combinedRangeMinMaxStats;
    private ZoneId timezone = ZoneId.systemDefault();

    public Optional<PaginationDto> getPagination() {
        return Optional.ofNullable(this.pagination);
    }

    public static <R extends ReportDefinitionDto<?>> ReportEvaluationContext<R> fromReportEvaluation(ReportEvaluationInfo evaluationInfo) {
        ReportEvaluationContext context = new ReportEvaluationContext();
        context.setReportDefinition(evaluationInfo.getReport());
        context.setTimezone(evaluationInfo.getTimezone());
        context.setPagination(evaluationInfo.getPagination().orElse(null));
        context.setCsvExport(evaluationInfo.isCsvExport());
        context.setJsonExport(evaluationInfo.isJsonExport());
        context.setHiddenFlowNodeIds(evaluationInfo.getHiddenFlowNodeIds());
        return context;
    }

    public R getReportDefinition() {
        return this.reportDefinition;
    }

    public boolean isCsvExport() {
        return this.isCsvExport;
    }

    public boolean isJsonExport() {
        return this.isJsonExport;
    }

    public Set<String> getHiddenFlowNodeIds() {
        return this.hiddenFlowNodeIds;
    }

    public MinMaxStatDto getCombinedRangeMinMaxStats() {
        return this.combinedRangeMinMaxStats;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public void setReportDefinition(R reportDefinition) {
        this.reportDefinition = reportDefinition;
    }

    public void setPagination(PaginationDto pagination) {
        this.pagination = pagination;
    }

    public void setCsvExport(boolean isCsvExport) {
        this.isCsvExport = isCsvExport;
    }

    public void setJsonExport(boolean isJsonExport) {
        this.isJsonExport = isJsonExport;
    }

    public void setHiddenFlowNodeIds(Set<String> hiddenFlowNodeIds) {
        this.hiddenFlowNodeIds = hiddenFlowNodeIds;
    }

    public void setCombinedRangeMinMaxStats(MinMaxStatDto combinedRangeMinMaxStats) {
        this.combinedRangeMinMaxStats = combinedRangeMinMaxStats;
    }

    public void setTimezone(ZoneId timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportEvaluationContext;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "ReportEvaluationContext(reportDefinition=" + String.valueOf(this.getReportDefinition()) + ", pagination=" + String.valueOf(this.getPagination()) + ", isCsvExport=" + this.isCsvExport() + ", isJsonExport=" + this.isJsonExport() + ", hiddenFlowNodeIds=" + String.valueOf(this.getHiddenFlowNodeIds()) + ", combinedRangeMinMaxStats=" + String.valueOf(this.getCombinedRangeMinMaxStats()) + ", timezone=" + String.valueOf(this.getTimezone()) + ")";
    }
}

