/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.report.CombinedIntervalSelectionCalculator;
import io.camunda.optimize.service.db.report.CombinedReportInstanceCounter;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.ExecutionContextFactory;
import io.camunda.optimize.service.db.report.ExecutionPlanExtractor;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.SingleReportEvaluator;
import io.camunda.optimize.service.db.report.interpreter.plan.ExecutionPlanInterpreterFacade;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CombinedReportEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedReportEvaluator.class);
    private final ExecutionPlanExtractor executionPlanExtractor;
    private final ExecutionPlanInterpreterFacade interpreter;
    private final SingleReportEvaluator singleReportEvaluator;
    private final CombinedReportInstanceCounter<?> combinedReportInstanceCounter;

    public CombinedReportEvaluator(ExecutionPlanExtractor executionPlanExtractor, ExecutionPlanInterpreterFacade interpreter, SingleReportEvaluator singleReportEvaluator, CombinedReportInstanceCounter<?> combinedReportInstanceCounter) {
        this.executionPlanExtractor = executionPlanExtractor;
        this.interpreter = interpreter;
        this.singleReportEvaluator = singleReportEvaluator;
        this.combinedReportInstanceCounter = combinedReportInstanceCounter;
    }

    public <T> List<SingleReportEvaluationResult<T>> evaluate(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions, ZoneId timezone) {
        MinMaxStatDto combinedRangeMinMaxStats;
        try {
            combinedRangeMinMaxStats = this.getGlobalMinMaxStats(singleReportDefinitions, timezone).orElse(null);
        }
        catch (OptimizeValidationException e) {
            LOG.error("Failed to evaluate combined report! Reason: ", (Throwable)((Object)e));
            return List.of();
        }
        return singleReportDefinitions.stream().map(report -> this.evaluateWithoutThrowingError((SingleProcessReportDefinitionRequestDto)report, combinedRangeMinMaxStats, timezone)).filter(Optional::isPresent).map(Optional::get).map(result -> result).collect(Collectors.toList());
    }

    public long evaluateCombinedReportInstanceCount(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions) {
        if (CollectionUtils.isEmpty(singleReportDefinitions)) {
            return 0L;
        }
        try {
            return this.combinedReportInstanceCounter.count(singleReportDefinitions);
        }
        catch (OptimizeValidationException e) {
            LOG.error("Failed to evaluate combined report instance count! Reason: ", (Throwable)((Object)e));
            return 0L;
        }
    }

    private Optional<MinMaxStatDto> getGlobalMinMaxStats(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions, ZoneId timezone) {
        CombinedIntervalSelectionCalculator combinedIntervalCalculator = new CombinedIntervalSelectionCalculator();
        singleReportDefinitions.forEach(reportDefinition -> {
            ExecutionPlan plan = this.executionPlanExtractor.extractExecutionPlans(reportDefinition).get(0);
            ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> reportEvaluationContext = new ReportEvaluationContext<SingleProcessReportDefinitionRequestDto>();
            reportEvaluationContext.setReportDefinition((SingleProcessReportDefinitionRequestDto)reportDefinition);
            reportEvaluationContext.setTimezone(timezone);
            ExecutionContext executionContext = ExecutionContextFactory.buildExecutionContext(plan, reportEvaluationContext);
            Optional<MinMaxStatDto> minMaxStatDto = this.interpreter.getGroupByMinMaxStats(executionContext);
            minMaxStatDto.ifPresent(combinedIntervalCalculator::addStat);
        });
        return combinedIntervalCalculator.getGlobalMinMaxStats();
    }

    private Optional<SingleReportEvaluationResult<?>> evaluateWithoutThrowingError(SingleProcessReportDefinitionRequestDto reportDefinition, MinMaxStatDto combinedRangeMinMaxStats, ZoneId timezone) {
        Optional<SingleReportEvaluationResult<Object>> result = Optional.empty();
        try {
            ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> reportEvaluationContext = new ReportEvaluationContext<SingleProcessReportDefinitionRequestDto>();
            reportEvaluationContext.setReportDefinition(reportDefinition);
            reportEvaluationContext.setTimezone(timezone);
            reportEvaluationContext.setCombinedRangeMinMaxStats(combinedRangeMinMaxStats);
            SingleReportEvaluationResult<Object> singleResult = this.singleReportEvaluator.evaluate(reportEvaluationContext);
            result = Optional.of(singleResult);
        }
        catch (OptimizeException | OptimizeValidationException onlyForLogging) {
            LOG.debug("Single report with id [{}] could not be evaluated for a combined report.", (Object)reportDefinition.getId(), onlyForLogging);
        }
        return result;
    }
}

