/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report;

import io.camunda.optimize.service.db.report.MinMaxStatDto;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class CombinedIntervalSelectionCalculator {
    private final List<MinMaxStatDto> minMaxStats = new ArrayList<MinMaxStatDto>();

    public void addStat(MinMaxStatDto minMaxStat) {
        this.minMaxStats.add(minMaxStat);
    }

    public Optional<MinMaxStatDto> getGlobalMinMaxStats() {
        Optional<MinMaxStatDto> globalMaxStat = this.minMaxStats.stream().filter(MinMaxStatDto::isMaxValid).max(Comparator.comparing(MinMaxStatDto::getMax));
        Optional<MinMaxStatDto> globalMinStat = this.minMaxStats.stream().filter(MinMaxStatDto::isMinValid).min(Comparator.comparing(MinMaxStatDto::getMin));
        if (globalMaxStat.isPresent() && globalMinStat.isPresent()) {
            MinMaxStatDto minStat = globalMinStat.get();
            MinMaxStatDto maxStat = globalMaxStat.get();
            return Optional.of(new MinMaxStatDto(minStat.getMin(), maxStat.getMax(), minStat.getMinAsString(), maxStat.getMaxAsString()));
        }
        return Optional.empty();
    }
}

